% Two SSB QPSK signals are modulated, multiplexed and demodulated
%
global T n NTS NSYM time tindex freq bindex h1 h2 h3 h4 h5 h6 h7 h8 h9 h10 h11 h12 h13 h14 h15 h16 h17 h18 h19 h20
%
c0=2.9979e8;        % Light speed in vacuum
Lambda=1550e-9;     % Vacuum wavelength of the optical carrier
f0=c0/Lambda;       % Frequency of the optical carrier
T=1/f0;             % Period of the optical carrier
%
%____________________________ FFT PARAMETERS ______________________________
%
NSYM=2048;          % Frequency resolution: df=f0/(2*NSYM)
NTS=1024;            % Time resolution: dt=T/NTS
%
% Time and Frequency Parameters Assignment
%
NTR=40;              % Number of unity intervals to the right of pulse center
NTL=40;              % Number of unity intervals to the left of pulse center
NB=2;               % Multiples of the optical carrier frequency plotted in each semi-axis
freq=(-NTS/2:1/(2*NSYM):(NTS-1/NSYM)/2); % Normalized frequency axis. Normalization f0=1/T
findex=(NTS*NSYM+1:NTS*NSYM+1+NB*2*NSYM);
fplot=freq(findex)/T/1e12; % Unilateral dimensional frequency axis in Thz for plotting functions
bindex=(NTS*NSYM+1-NB*2*NSYM:NTS*NSYM+1+NB*2*NSYM);
bplot=freq(bindex)/T/1e12; % Bilateral dimensional frequency axis in THz for plotting functions
time=(-NSYM:1/NTS:NSYM-1/NTS); % Normalized time axis. Normalization T
tindex=(NTS*NSYM+1-NTL*NTS:NTS*NSYM+1+NTR*NTS); % Temporal axis for pulse representation. Pulse is zero outside
tplot=time(tindex)*T*1e15; % Dimensional temporal axis in fs for plotting output pulse
%
%_________________________________ SIGNALS ________________________________
%
n=20; % Ratio between the carrier frequency and the cutoff frequency of the Gaussian spectrum
I=cos(2*pi*time); % In-phase carrier (cosine function at the unit frequency)
Q=sin(2*pi*time); % Quadrature carrier (sine function at the unit frequency)
H=-1i*sign(freq); % Hilbert filter
LPF=zeros(1,2*NTS*NSYM);
LPF(NTS*NSYM+1-NSYM:NTS*NSYM+1+NSYM)=1;
%
%------------------- I and Q tributaries for channel 1 --------------------
%
P1I=input('First channel In-phase (1I) signal (S, G, R, B, W, E) [null]: ','s');
P1Q=input('First channel Quadrature (1Q) signal (S, G, R, B, W, E) [null]: ','s');
r1I=SWITCH_PULSE(P1I);
r1Q=SWITCH_PULSE(P1Q);
%
%--------------------- Modulation channel 1 SSB-QPSK ----------------------
%
% Generation of the harmonic conjugates x1I(t) and x1Q(t)
%
R1I=SPECTRUM(r1I); % Spectrum of the In-phase reference function
X1I=R1I.*H; % Spectrum of the harmonic conjugate x1I(t) of r1I(t)
x1I=PULSE(X1I); % Harmonic conjugate of the In-phase function
R1Q=SPECTRUM(r1Q); % Spectrum of the Quadrature reference function
X1Q=R1Q.*H; % Spectrum of the harmonic conjugate x1Q(t) of r1Q(t)
x1Q=PULSE(X1Q); % Harmonic conjugate of the Quadrature function
%
% SSB QPSK modulation formats
%
f1_ILQU=(r1I+x1Q).*I+(r1Q+x1I).*Q; % Time domain signal 1 ILQU-QPSK (Heterogeneous)
f1_IUQL=(r1I-x1Q).*I+(r1Q-x1I).*Q; % Time domain signal 1 IUQL-QPSK (Heterogeneous)
f1_ILQL=(r1I-x1Q).*I+(r1Q+x1I).*Q; % Time domain signal 1 ILQL-QPSK (Homogeneous LSSB)
f1_IUQU=(r1I+x1Q).*I+(r1Q-x1I).*Q; % Time domain signal 1 IUQU-QPSK (Homogeneous USSB)
F1_ILQU=SPECTRUM(f1_ILQU); % Spectrum 1 ILQU-QPSK (Heterogeneous)
F1_IUQL=SPECTRUM(f1_IUQL); % Spectrum 1 IUQL-QPSK (Heterogeneous)
F1_ILQL=SPECTRUM(f1_ILQL); % Spectrum 1 ILQL-QPSK (Homogeneous LSSB)
F1_IUQU=SPECTRUM(f1_IUQU); % Spectrum 1 IUQU-QPSK (Homogeneous USSB)
%
%-------------------- Demodulation channel 1 SSB-QPSK ---------------------
Legend11=['f_1  ';'r_1_I';'x_1_I'];
Legend21=['f_1  ';'r_1_Q';'x_1_Q'];
%
% A - Source spectrum ILQU SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f1_ILQU,I,Q,H);
if isempty(h1), % Create the figure with the handle h1
    h1=figure('Name','Channel 1 - Spectra ILQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h1); clf; % Recall the figure using the handle h1
end;
GRAPH_SPECTRUM_QPSK('ILQU',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_ILQU,F1_ILQU,Out1,Out2,Out3,Out4);
%
if isempty(h2), % Create the figure with the handle h2
    h2=figure('Name','Channel 1 - Base-band signals ILQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h2); clf; % Recall the figure using the handle h2
end;
GRAPH_SIGNAL_QPSK('ILQU',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_ILQU,F1_ILQU,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% B - Source spectrum IUQL SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f1_IUQL,I,Q,H);
if isempty(h3), % Create the figure with the handle h3
    h3=figure('Name','Channel 1 - Spectra IUQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h3); clf; % Recall the figure using the handle h3
end;
GRAPH_SPECTRUM_QPSK('IUQL',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_IUQL,F1_IUQL,Out1,Out2,Out3,Out4);
%
if isempty(h4), % Create the figure with the handle h4
    h4=figure('Name','Channel 1 - Base-band signals IUQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h4); clf; % Recall the figure using the handle h4
end;
GRAPH_SIGNAL_QPSK('IUQL',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_IUQL,F1_IUQL,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% C - Source spectrum ILQL SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f1_ILQL,I,Q,H);
if isempty(h5), % Create the figure with the handle h5
    h5=figure('Name','Channel 1 - Spectra ILQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h5); clf; % Recall the figure using the handle h5
end;
GRAPH_SPECTRUM_QPSK('ILQL',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_ILQL,F1_ILQL,Out1,Out2,Out3,Out4);
%
if isempty(h6), % Create the figure with the handle h6
    h6=figure('Name','Channel 1 - Base-band signals ILQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h6); clf; % Recall the figure using the handle h6
end;
GRAPH_SIGNAL_QPSK('ILQL',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_ILQL,F1_ILQL,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% D - Source spectrum IUQU SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f1_IUQU,I,Q,H);
if isempty(h7), % Create the figure with the handle h7
    h7=figure('Name','Channel 1 - Spectra IUQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h7); clf; % Recall the figure using the handle h7
end;
GRAPH_SPECTRUM_QPSK('IUQU',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_IUQU,F1_IUQU,Out1,Out2,Out3,Out4);
%
if isempty(h8), % Create the figure with the handle h8
    h8=figure('Name','Channel 1 - Base-band signals IUQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h8); clf; % Recall the figure using the handle h8
end;
GRAPH_SIGNAL_QPSK('IUQU',Legend11,Legend21,r1I,x1I,r1Q,x1Q,R1I,X1I,R1Q,X1Q,f1_IUQU,F1_IUQU,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
%------------------- I and Q tributaries for channel 2 --------------------
%
P2I=input('Second channel In-phase (2I) signal (S, G, R, B, W, E) [null]: ','s');
P2Q=input('Second channel Quadrature (2Q) signal (S, G, R, B, W, E) [null]: ','s');
r2I=SWITCH_PULSE(P2I);
r2Q=SWITCH_PULSE(P2Q);
%
%--------------------- Modulation channel 2 SSB-QPSK ----------------------
%
% Generation of the harmonic conjugates x2I(t) and x2Q(t)
%
R2I=SPECTRUM(r2I); % Spectrum of the In-phase reference function
X2I=R2I.*H; % Spectrum of the harmonic conjugate x2I(t) of r2I(t)
x2I=PULSE(X2I); % Harmonic conjugate of the In-phase function
R2Q=SPECTRUM(r2Q); % Spectrum of the Quadrature reference function
X2Q=R2Q.*H; % Spectrum of the harmonic conjugate x2Q(t) of r2Q(t)
x2Q=PULSE(X2Q); % Harmonic conjugate of the Quadrature function
%
% SSB QPSK modulation formats
%
f2_ILQU=(r2I+x2Q).*I+(r2Q+x2I).*Q; % Time domain signal 2 ILQU-QPSK (Heterogeneous)
f2_IUQL=(r2I-x2Q).*I+(r2Q-x2I).*Q; % Time domain signal 2 IUQL-QPSK (Heterogeneous)
f2_ILQL=(r2I-x2Q).*I+(r2Q+x2I).*Q; % Time domain signal 2 ILQL-QPSK (Homogeneous LSSB)
f2_IUQU=(r2I+x2Q).*I+(r2Q-x2I).*Q; % Time domain signal 2 IUQU-QPSK (Homogeneous USSB)
F2_ILQU=SPECTRUM(f2_ILQU); % Spectrum 1 ILQU-QPSK (Heterogeneous)
F2_IUQL=SPECTRUM(f2_IUQL); % Spectrum 1 IUQL-QPSK (Heterogeneous)
F2_ILQL=SPECTRUM(f2_ILQL); % Spectrum 1 ILQL-QPSK (Homogeneous LSSB)
F2_IUQU=SPECTRUM(f2_IUQU); % Spectrum 1 IUQU-QPSK (Homogeneous USSB)
%
%-------------------- Demodulation channel 1 SSB-QPSK ---------------------
Legend11=['f_2  ';'r_2_I';'x_2_I'];
Legend21=['f_2  ';'r_2_Q';'x_2_Q'];
%
% A - Source spectrum ILQU SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f2_ILQU,I,Q,H); % 
if isempty(h9), % Create the figure with the handle h9
    h9=figure('Name','Channel 2 - Spectra ILQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h9); clf; % Recall the figure using the handle h9
end;
GRAPH_SPECTRUM_QPSK('ILQU',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_ILQU,F2_ILQU,Out1,Out2,Out3,Out4);
%
if isempty(h10), % Create the figure with the handle h10
    h10=figure('Name','Channel 2 - Base-band signals ILQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h10); clf; % Recall the figure using the handle h10
end;
GRAPH_SIGNAL_QPSK('ILQU',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_ILQU,F2_ILQU,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% B - Source spectrum IUQL SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f2_IUQL,I,Q,H); 
if isempty(h11), % Create the figure with the handle h11
    h11=figure('Name','Channel 2 - Spectra IUQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h11); clf; % Recall the figure using the handle h11
end;
GRAPH_SPECTRUM_QPSK('IUQL',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_IUQL,F2_IUQL,Out1,Out2,Out3,Out4);
%
if isempty(h12), % Create the figure with the handle h12
    h12=figure('Name','Channel 2 - Base-band signals IUQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h12); clf; % Recall the figure using the handle h12
end;
GRAPH_SIGNAL_QPSK('IUQL',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_IUQL,F2_IUQL,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% C - Source spectrum ILQL SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f2_ILQL,I,Q,H);
if isempty(h13), % Create the figure with the handle h13
    h13=figure('Name','Channel 2 - Spectra ILQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h13); clf; % Recall the figure using the handle h13
end;
GRAPH_SPECTRUM_QPSK('ILQL',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_ILQL,F2_ILQL,Out1,Out2,Out3,Out4);
%
if isempty(h14), % Create the figure with the handle h14
    h14=figure('Name','Channel 2 - Base-band signals ILQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h14); clf; % Recall the figure using the handle h14
end;
GRAPH_SIGNAL_QPSK('ILQL',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_ILQL,F2_ILQL,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% D - Source spectrum IUQU SSB QPSK
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f2_IUQU,I,Q,H);
if isempty(h15), % Create the figure with the handle h15
    h15=figure('Name','Channel 2 - Spectra IUQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h15); clf; % Recall the figure using the handle h15
end;
GRAPH_SPECTRUM_QPSK('IUQU',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_IUQU,F2_IUQU,Out1,Out2,Out3,Out4);
%
if isempty(h16), % Create the figure with the handle h16
    h16=figure('Name','Channel 2 - Base-band signals IUQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h16); clf; % Recall the figure using the handle h16
end;
GRAPH_SIGNAL_QPSK('IUQU',Legend11,Legend21,r2I,x2I,r2Q,x2Q,R2I,X2I,R2Q,X2Q,f2_IUQU,F2_IUQU,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
%-------------------------------- MUX -------------------------------------
%
f12_Hetero=f1_IUQL+f2_ILQU;
f12_Homo=f1_IUQU+f2_ILQL;
F12_Hetero=SPECTRUM(f12_Hetero);
F12_Homo=SPECTRUM(f12_Homo);
%
%-------------------- DEMUX and Demodulation SSB-QPSK ---------------------
%
Legend11=['f_1_2';'r_1_I';'r_1_Q'];
Legend21=['f_1_2';'r_2_I';'r_2_Q'];
%
% A - Heterogeneous MUX source spectrum IUQL+ILQU
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f12_Hetero,I,Q,H); % 
if isempty(h17), % Create the figure with the handle h17
    h17=figure('Name','Heterogeneous MUX spectrum IUQL+ILQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h17); clf; % Recall the figure using the handle h17
end;
GRAPH_SPECTRUM_QPSK('IUQL+ILQU',Legend11,Legend21,r1I,r1Q,r2I,r2Q,R1I,R1Q,R2I,R2Q,f12_Hetero,F12_Hetero,Out1,Out2,Out3,Out4);
%
if isempty(h18), % Create the figure with the handle h18
    h18=figure('Name','Heterogeneous MUX signal IUQL+ILQU SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h18); clf; % Recall the figure using the handle h18
end;
GRAPH_SIGNAL_QPSK('IUQL+ILQU',Legend11,Legend21,r1I,r1Q,r2I,r2Q,R1I,R1Q,R2I,R2Q,f12_Hetero,F12_Hetero,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
%
% B - Homogeneous MUX source spectrum IUQU+ILQL
%
[Out1, Out2, Out3, Out4]=DEMOD_QPSK(f12_Homo,I,Q,H); 
if isempty(h19), % Create the figure with the handle h19
    h19=figure('Name','Homogeneous MUX spectrum IUQU+ILQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h19); clf; % Recall the figure using the handle h19
end;
GRAPH_SPECTRUM_QPSK('IUQU+ILQL',Legend11,Legend21,r1I,r1Q,r2I,r2Q,R1I,R1Q,R2I,R2Q,f12_Homo,F12_Homo,Out1,Out2,Out3,Out4);
%
if isempty(h20), % Create the figure with the handle h20
    h20=figure('Name','Homogeneous MUX signal IUQU+ILQL SSB QPSK','Unit','normalized','Position',[0.05 0.05 0.9 0.85]);
else
    figure(h20); clf; % Recall the figure using the handle h20
end;
GRAPH_SIGNAL_QPSK('IUQU+ILQL',Legend11,Legend21,r1I,r1Q,r2I,r2Q,R1I,R1Q,R2I,R2Q,f12_Homo,F12_Homo,PULSE(Out1.*LPF),PULSE(Out2.*LPF),PULSE(Out3.*LPF),PULSE(Out4.*LPF));
