% program chap10_1.m
% program implements dort time reversal imaging at single frequency in 2D
% homogeneous space
% uses co-incident arrays
% written by A.J. Devaney April, 2011
% generates fig. 10.1 in chapter 10 of book
clear all;
global lambda xalpha xbeta yalpha ybeta  
lambda=1;
% 
% set up NXN image  grid
%
N=257;
deltax=lambda/8;
deltay=deltax;
x=deltax*[-(N-1)/2:+(N-1)/2];
y=deltay*[0:N-1];
% size of arrays
Nalpha=11; Nbeta=11;
for nct=1:2;
%
% input scatterer locations and strengths
%
M=3;
if nct==1;
  X(1)=0; Y(1)=10*lambda; V(1)=1;
 X(2)=-5*lambda; Y(2)=5*lambda; V(2)=1;
 X(3)=10*lambda; Y(3)=16*lambda;V(3)=1;
 Xp=[X(1),X(2),X(3)]; Yp=[Y(1),Y(2),Y(3)];
 delxa=2*lambda;
 Nalpha=11; Nbeta=11;
else
 X(1)=0; Y(1)=5*lambda; V(1)=1;
 X(2)=0; Y(2)=20*lambda; V(2)=1;
 X(3)=0; Y(3)=15*lambda;V(3)=1;
%   X(1)=0; Y(1)=10*lambda; V(1)=1;
%  X(2)=-5*lambda; Y(2)=5*lambda; V(2)=1;
%  X(3)=10*lambda; Y(3)=16*lambda;V(3)=1;
 delxa=2*lambda;
Nalpha=11; Nbeta=11; 
end;
  delya=0;  xa0=0; ya0=0; 
xalpha=xa0+delxa*[-(Nalpha-1)/2:1:(Nalpha-1)/2];
yalpha=ya0+delya*[0:1:(Nalpha-1)];
xbeta=xalpha;
ybeta=yalpha;
%
% input scatterer locations and strengths
%
% compute multistatic data matrix
%
K=multistatic1(X,Y,V);
%
%[X,Y]=meshgrid(x,y);
% 
% compute G(r,r_b).*G(r,r_a) over image space parameterized by r_a, r_b
%
for na=1:Nalpha;
    xa=x-xalpha(na);
        ya=y-yalpha(na);
        [Xa,Ya]=meshgrid(xa,ya);
        Ra=sqrt(Xa.^2+Ya.^2);
ga(:,:,na)=-i/4*besselh(0,1,Ra);
end;        
    for nb=1:Nbeta;
        xb=x-xbeta(nb);
        yb=y-ybeta(nb);
        [Xb,Yb]=meshgrid(xb,yb);
        Rb=sqrt(Xb.^2+Yb.^2);
        gb(:,:,nb)=-i/4*besselh(0,1,Rb);
    end;
%
% now do classical Dort
% u and v are constructed from svd column vectors
%
[u,s,v] = svd(K);
sig(:,nct)=diag(s);
imagea=zeros(N,N);imageb=zeros(N,N);imagec=zeros(N,N);
for na=1:Nalpha;
       imagea=imagea+v(na,1)*ga(:,:,na);
       imageb=imageb+v(na,2)*ga(:,:,na);
       imagec=imagec+v(na,3)*ga(:,:,na);
    end;
image1(:,:,nct)=imagea;image2(:,:,nct)=imageb;image3(:,:,nct)=imagec;
%
%
% now generate filtered dort with F(m)=\sigma_m
%
image=zeros(N,N);
for na=1:Nalpha;
    for nb=1:Nbeta;
        image=image+conj(K(nb,na))*gb(:,:,nb).*ga(:,:,na);
    end;
end;
imaged(:,:,nct)=image;
%
% now generate filtered dort with F(m)=1
%
imagedd(:,:,nct)=imagea+imageb+imagec;
end;
Sig=num2str(sig(1:3,:),2);
tit1a=[' \sigma_1= ',Sig(1,1:7)];
tit1b=[' \sigma_2= ',Sig(2,1:7)];
tit1c=[' \sigma_3= ',Sig(3,1:7)];
tit2a=[' \sigma_1= ',Sig(1,7:14)];
tit2b=[' \sigma_2= ',Sig(2,7:14)];
tit2c=[' \sigma_3= ',Sig(3,7:14)];
    clf;
subplot(2,3,1)
imagesc(x,y,(abs(image1(:,:,1))));
axis equal
title(tit1a);
hold on
ht=plot(Xp,Yp,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
%
%plot(xalpha,sig(:,1),'*')
%hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
%set(hb,'markerfacecolor','w')
axis off 
subplot(2,3,2)
imagesc(x,y,(abs(image2(:,:,1))));
axis equal
title(tit1b);
hold on
ht=plot(Xp,Yp,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
%hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
%set(hb,'markerfacecolor','w')
axis off 
subplot(2,3,3)
imagesc(x,y,(abs(image3(:,:,1))));
axis equal
title(tit1c);
hold on
ht=plot(Xp,Yp,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
%hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
%set(hb,'markerfacecolor','w')
axis off 
subplot(2,3,4)
imagesc(x,y,(abs(image1(:,:,2))));
axis equal
title(tit2a);
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
%hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
%set(hb,'markerfacecolor','w')
axis off 
subplot(2,3,5)
imagesc(x,y,(abs(image2(:,:,2))));
axis equal
title(tit2b);
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
%hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
%set(hb,'markerfacecolor','w')
axis off 
subplot(2,3,6)
imagesc(x,y,(abs(image3(:,:,2))));
axis equal
title(tit2c);
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
%hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
%set(hb,'markerfacecolor','w')
axis off 
pause;
%
% now generate filtered dort images
%
clf;
subplot(2,2,1)
imagesc(x,y,abs(imaged(:,:,1)));
axis equal
hold on
ht=plot(Xp,Yp,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
axis off
subplot(2,2,2)
imagesc(x,y,abs(imaged(:,:,2)));
axis equal 
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
axis off
subplot(2,2,3)
imagesc(x,y,abs(imagedd(:,:,1)));
axis equal
hold on
ht=plot(Xp,Yp,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
axis off
subplot(2,2,4)
imagesc(x,y,abs(imagedd(:,:,2)));
axis equal 
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
axis off



        
