% program chap10_2.m
% program implements dort time reversal imaging at single frequency in 2D
% homogeneous space
% written by A.J. Devaney April 2011
% used to generate figs. 10.2 and 10.3 in book
clear all;
global lambda xalpha xbeta yalpha ybeta  
lambda=1;
% 
% set up NXN image  grid
%
N=257;
deltax=lambda/8;
deltay=deltax;
x=deltax*[-(N-1)/2:+(N-1)/2];
y=deltay*[0:N-1];
% size of beta and beta arrays
Nalpha=11; Nbeta=11;
choice=input('input 1 for coincident arrays or 2 for non-coincident arrays: choice=  ');
if choice==1;
    delxa=2*lambda; delxb=delxa; delya=0; delyb=delya; xa0=0; xb0=0; ya0=0; yb0=0;
else 
   delxa=2*lambda; delxb=0; delya=0; delyb=delxa; xa0=0; xb0=-(N-1)/2*deltax; yb0=(N-1)/2*deltay-(Nbeta-1)/2*delyb; ya0=0;
end;
xalpha=xa0+delxa*[-(Nalpha-1)/2:1:(Nalpha-1)/2];
yalpha=ya0+delya*[0:1:(Nalpha-1)];
xbeta=xb0+delxb*[-(Nbeta-1)/2:1:(Nbeta-1)/2];
ybeta=yb0+delyb*[0:1:(Nbeta-1)];
%
% input scatterer locations and strengths
%
M=3;
%   X(1)=lambda; Y(1)=10*lambda; V(1)=1;
%  X(2)=-5*lambda; Y(2)=5*lambda; V(2)=1;
%  X(3)=10*lambda; Y(3)=16*lambda;V(3)=1;
X(1)=0; Y(1)=5*lambda; V(1)=1;
 X(2)=8*lambda; Y(2)=10*lambda; V(2)=1;
 X(3)=-10*lambda; Y(3)=15*lambda;V(3)=1;
% compute multistatic data matrix
%
K=multistatic1(X,Y,V);
% scatterer locations
% for m=1:M;
%     xm(m)=min(find(abs(x-X(m))<=deltax));
%     ym(m)=min(find(abs(y-Y(m))<=deltax));
% end;
%[X,Y]=meshgrid(x,y);
% 
% compute G(r,r_b).*G(r,r_a) over image space parameterized by r_a, r_b
%
for na=1:Nalpha;
    xa=x-xalpha(na);
        ya=y-yalpha(na);
        [Xa,Ya]=meshgrid(xa,ya);
        Ra=sqrt(Xa.^2+Ya.^2);
ga(:,:,na)=-i/4*besselh(0,1,Ra);
end;        
    for nb=1:Nbeta;
        xb=x-xbeta(nb);
        yb=y-ybeta(nb);
        [Xb,Yb]=meshgrid(xb,yb);
        Rb=sqrt(Xb.^2+Yb.^2);
        gb(:,:,nb)=-i/4*besselh(0,1,Rb);
    end;
%
% generate dort images
%
% first generate filtered dort with F(m)=\sigma_m
%
% image=zeros(N,N);
% for na=1:Nalpha;
%     for nb=1:Nbeta;
%         image=image+conj(K(nb,na))*gb(:,:,nb).*ga(:,:,na);
%     end;
% end;
% clf;
% subplot(2,2,1)
% imagesc(x,y,abs(image));
% text(X,Y,'*');
% title('basic filtered DORT')
%
% now do classical Dort
% u and v are constructed from svd column vectors
%
[u,s,v] = svd(K);
sig=diag(s);
Sig=num2str(sig(1:3),2);
tit1a=[' \sigma_1= ',Sig(1)];
tit1b=[' \sigma_2= ',Sig(2)];
tit1c=[' \sigma_3= ',Sig(3)];
image1=zeros(N,N);image2=zeros(N,N);
for na=1:Nalpha;
       image1=image1+v(na,1)*ga(:,:,na);
    end;
    for nb=1:Nbeta;
        image2=image2+conj(u(nb,1))*gb(:,:,nb);
    end;
      clf;
      image_1=image1.*image2;
 subplot(2,3,1)
imagesc(x,y,abs(image1));
hold on
axis equal
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
title('Image  from 1st singular vector of \alpha array');
ha=plot(xalpha,yalpha,'^k');
hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
set(hb,'markerfacecolor','w')
axis off
 subplot(2,3,4)
imagesc(x,y,abs(image2));
axis equal
title('Image from 1st singular vector of \beta array');
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
set(hb,'markerfacecolor','w')
axis off
image1=zeros(N,N);image2=zeros(N,N);
for na=1:Nalpha;
       image1=image1+v(na,2)*ga(:,:,na);
    end;
    for nb=1:Nbeta;
        image2=image2+conj(u(nb,2))*gb(:,:,nb);
    end;
    image_2=image1.*image2;
 subplot(2,3,2)
imagesc(x,y,abs(image1));
axis equal
title('Image  from 2nd singular vector of \alpha array');
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
set(hb,'markerfacecolor','w')
axis off
 subplot(2,3,5)
imagesc(x,y,abs(image2));
axis equal
title('Image from 2nd singular vector of \beta array');
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
set(hb,'markerfacecolor','w')
axis off 
image1=zeros(N,N);image2=zeros(N,N);
for na=1:Nalpha;
       image1=image1+v(na,3)*ga(:,:,na);
    end;
    for nb=1:Nbeta;
        image2=image2+conj(u(nb,3))*gb(:,:,nb);
    end;
    image_3=image1.*image2;
 subplot(2,3,3)
imagesc(x,y,abs(image1));
axis equal
title('Image  from 3rd singular vector of \alpha array');
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
set(hb,'markerfacecolor','w')
axis off
 subplot(2,3,6)
imagesc(x,y,abs(image2));
axis equal
title('Image from 3rd singular vector of \beta array');
hold on
ht=plot(X,Y,'ko');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
hb=plot(xbeta,ybeta,'<k');
set(ha,'markerfacecolor','w');
set(hb,'markerfacecolor','w')
axis off 
% pause;
% clf
% subplot(1,3,1)
% imagesc(x,y,sqrt(abs(image_1)));
% axis equal
% title('Composite image from 1st singular vector');
% hold on
% ht=plot(X,Y,'ko');
% set(ht,'markerfacecolor','k');
% ha=plot(xalpha,yalpha,'^k');
% hb=plot(xbeta,ybeta,'<k');
% set(ha,'markerfacecolor','w');
% set(hb,'markerfacecolor','w')
% axis off 
% subplot(1,3,2)
% imagesc(x,y,sqrt(abs(image_2)));
% axis equal
% title('Composite image from 2nd singular vector');
% hold on
% ht=plot(X,Y,'ko');
% set(ht,'markerfacecolor','k');
% ha=plot(xalpha,yalpha,'^k');
% hb=plot(xbeta,ybeta,'<k');
% set(ha,'markerfacecolor','w');
% set(hb,'markerfacecolor','w')
% axis off 
% subplot(1,3,3)
% imagesc(x,y,sqrt(abs(image_3)));
% axis equal
% title('Composite image from 3rd singular vector');
% hold on
% ht=plot(X,Y,'ko');
% set(ht,'markerfacecolor','k');
% ha=plot(xalpha,yalpha,'^k');
% hb=plot(xbeta,ybeta,'<k');
% set(ha,'markerfacecolor','w');
% set(hb,'markerfacecolor','w')
% axis off 





        
