% program chap9_3.m
% program implements  time reversal MUSIC imaging at single frequency in 2D
% homogeneous space
% uses single transmit and receive array
% written by A.J. Devaney April 2011
% used to generate fig.10.4 in book
clear all;
global lambda xalpha xbeta yalpha ybeta  
lambda=1;
% 
% set up NXN image  grid
%
N=257;
deltax=lambda/8;
deltay=deltax;
x=deltax*[-(N-1)/2:+(N-1)/2];
y=deltay*[0:N-1];
 delxa=2*lambda;
 Nalpha=11; Nbeta=11;
% size of arrays
Nalpha=11; Nbeta=11;
  delya=0;  xa0=0; ya0=0; 
xalpha=xa0+delxa*[-(Nalpha-1)/2:1:(Nalpha-1)/2];
yalpha=ya0+delya*[0:1:(Nalpha-1)];
xbeta=xalpha;
ybeta=yalpha;
% set up scatterer locations
M=3;
Xp(:,1)=[0,-5*lambda,5*lambda];
Xp(:,2)=[0,-5*lambda,2*lambda];
Xp(:,3)=[0,-5*lambda,-lambda];
Xp(:,4)=[0,-5*lambda,-4*lambda];
Yp(:,1)=[10*lambda,15*lambda,20*lambda];
Yp(:,2)=[10*lambda,13*lambda,15*lambda];
Yp(:,3)=[10*lambda,12*lambda,13*lambda];
Yp(:,4)=[10*lambda,11*lambda,12*lambda];
% Xp(:,1)=[0,-5*lambda,5*lambda];
% Xp(:,2)=[0,-5*lambda,2*lambda];
% Xp(:,3)=[0,-5*lambda,-lambda];
% Xp(:,4)=[0,-5*lambda,-4*lambda];
% Yp(:,1)=[5*lambda,10*lambda,15*lambda];
% Yp(:,2)=[5*lambda,8*lambda,10*lambda];
% Yp(:,3)=[5*lambda,7*lambda,8*lambda];
% Yp(:,4)=[5*lambda,6*lambda,7*lambda];
V=[1,1,1];
% 
% compute G(r,r_b).*G(r,r_a) over image space parameterized by r_a, r_b
%
for na=1:Nalpha;
    xa=x-xalpha(na);
        ya=y-yalpha(na);
        [Xa,Ya]=meshgrid(xa,ya);
        Ra=sqrt(Xa.^2+Ya.^2);
ga(:,:,na)=-i/4*besselh(0,1,Ra);
end;        
    for nb=1:Nbeta;
        xb=x-xbeta(nb);
        yb=y-ybeta(nb);
        [Xb,Yb]=meshgrid(xb,yb);
        Rb=sqrt(Xb.^2+Yb.^2);
        gb(:,:,nb)=-i/4*besselh(0,1,Rb);
    end;    % begin loop over different scatterer sets
for nct=1:4;
  X=Xp(:,nct);
  Y=Yp(:,nct);
%
% compute multistatic data matrix
%
K=multistatic1(X,Y,V);
%
%[X,Y]=meshgrid(x,y);

%
% generate MUSIC images
%
% u and v are constructed from svd column vectors
%
[u,s,v] = svd(K);
mr=rank(K);
 imagea=zeros(N,N);imageb=zeros(N,N);
for m=mr+1:Nalpha
   image1=zeros(N,N);
for na=1:Nalpha;
       image1=image1+v(na,m)*ga(:,:,na);
    end;
    imagea=abs(image1)+imagea;
   end;
   for m=mr+1:Nbeta;
       image2=zeros(N,N);
        for nb=1:Nbeta;
        image2=image2+conj(u(nb,m))*gb(:,:,nb);
    end;
    imageb=abs(image2)+imageb;
end;
phi(:,:,nct)=1./(imagea.*imageb+.005);
end;
clf;
subplot(2,2,1)
imagesc(x,y,phi(:,:,1));
axis equal
axis off
hold on
 ht=plot(Xp(:,1),Yp(:,1),'k.');
 set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
subplot(2,2,2)
imagesc(x,y,phi(:,:,2));
axis equal
axis off
hold on
ht=plot(Xp(:,2),Yp(:,2),'k.');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
subplot(2,2,3)
imagesc(x,y,phi(:,:,3));
axis equal
axis off
hold on
ht=plot(Xp(:,3),Yp(:,3),'k.');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');
subplot(2,2,4)
imagesc(x,y,phi(:,:,4));
axis equal
axis off
hold on
ht=plot(Xp(:,4),Yp(:,4),'k.');
set(ht,'markerfacecolor','k');
ha=plot(xalpha,yalpha,'^k');
set(ha,'markerfacecolor','w');






        
