% program chap_1.m
% program computes and plots singular values sigma_l illustrating
% essentially nr sources
% Generates fig.1.2 in chapter 1 of book
clear all;
L=(1:100);
ka=(10:20:90);
mtemp=repmat((pi./(2*ka)).',1,100);
temp=besselj(L+1/2,ka.').^2-besselj(L-1/2,ka.').*besselj(L+3/2,ka.');
%mu=mtemp.*(besselj(L+1/2,ka.').^2-besselj(L-1/2,ka.').*besselj(L+3/2,ka.'));
mu=mtemp.*temp;
maxx=max(mu.');
maxx=repmat(maxx,100,1);
mun=mu.'./maxx;
clf;
hp1=subplot(2,1,1);
h1=plot(L,mun,'k');
hlabx1=xlabel('index l');
hlaby1=ylabel('normalized  \mu_l^2 ');
ha1=gca;
grid;
%legend('ka=10','ka=30','ka=50','ka=70','ka=90');
hp2=subplot(2,1,2);
h2=semilogy(L,mun,'k');
ha2=gca;
hlabx2=xlabel('index l');
hlaby2=ylabel('log  normalized \mu_l^2 ');
grid;
set(h1,'linewidth',1.5,'color',[0 0 0]);
set(h2,'linewidth',1.5,'color',[0 0 0]);
set(ha1,'linewidth',1.25,'FontSize', 13);
set(ha2,'linewidth',1.25,'fontsize',13);
set(hlabx1,'fontsize',13);
set(hlabx2,'fontsize',13);
set(hlaby1,'fontsize',13);
set(hlaby2,'fontsize',13);