% chap4.1.m
% modification of chap5_1a.m 
% December 2007
% program implements the angular spectrum expansion of the wavelet field
% implements only in r.h.s. z>0 using homgeneous portion of spectrum
% 
% uses wavelet rad pattern
% generates figs 4.4-4.5 in chapter 4 of book.
clear all;
%
% first set wavelet parameter a
a=1;
% set maximum extent of transverse (rho) axis
a0=5*a;
facc=[0.1,1];
N=1024;
Nz=3;
lambda_min=facc(1)*a;
% 
% total number of rho and phi points
Nr=8*round(a0/lambda_min);
delphi=2*pi/Nr;
phi=delphi*[0:Nr-1]-pi;
delz=a;
delr=lambda_min/8;
% Also compute radiation patterns as functions of angle phi
% 
% begin loop over wavelengths
for n=1:2;
lambda=facc(n)*a;
lam(n)=lambda;
z=delz*[0:Nz-1];
rho=delr*[0:Nr-1];
% wavenumber k
k=2*pi/lambda;
% radiation pattern of wavelet source
frad(:,n)=exp(k*cos(phi))./exp(k*a);
% radiation pattern of disk source
fdisk(:,n)=2*besselj(1,k*a*(sin(phi)+eps))./(k*a*(sin(phi)+eps));
% K=transverse wavenumber limited to homogeneous region of spectrum
delK=k/N;
K=delK*[0:N-1];
gamma=sqrt(k^2-K.^2);
% compute angular spectrum
% fac1 is N x Nz
fac1=exp(i*gamma.'*z);
ap=exp(a*gamma)./(gamma*exp(k*a));
coef1=repmat(ap.',1,Nz);
% A is N x Nz;
A=i*coef1.*fac1;
% now take Hankel transform
% first construct Bessel kernal which is Nr x N
Kvec=repmat(K,Nr,1);
H=Kvec.*besselj(0,rho.'*K);
% now compute back propagted field
Qbkt=delK*H*A;
% Qbk(1:Nr,1:Nz,n)=Qbkt;
Qbk(1:Nr,1:Nz,n)=Qbkt;
end;
% plot radiation patterns
clf;
gap=plot(phi,frad(:,1),'k:',phi,frad(:,2),'k:',phi,real(fdisk(:,1)),'k-',phi,real(fdisk(:,2)),'k-');
axis([-pi +pi -.2  1.2]);
ga=gca;
hline=get(ga,'children');
set(hline(3),'linewidth',2.5);
set(hline(4),'linewidth',2.5);
set(hline(1),'linewidth',1.25);
set(hline(2),'linewidth',1.25);
set(ga,'fontsize',13,'xminortick','on')
xlabel('angle in radians');
pause;
% use pol2cart: polcart(phi,R(phi))
[Phi,Rho]=ndgrid(phi.',rho);
[X,Y]=pol2cart(Phi,Rho);
for m=1:2;
   for n=1:3;
Q(:,:,n,m)=repmat(squeeze(Qbk(:,n,m)).',Nr,1);
end;
end;
Lambda=num2str(lam,2);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(2,3,1)
mesh(X,Y,real(squeeze(Q(:,:,1,1))));
subplot(2,3,2)
mesh(X,Y,real(squeeze(Q(:,:,2,1))));
subplot(2,3,3)
mesh(X,Y,real(squeeze(Q(:,:,3,1))));
subplot(2,3,4)
mesh(X,Y,real(squeeze(Q(:,:,1,2))));
subplot(2,3,5)
mesh(X,Y,real(squeeze(Q(:,:,2,2))));
subplot(2,3,6)
mesh(X,Y,real(squeeze(Q(:,:,3,2))));
pause;
subplot(2,3,1)
mesh(X,Y,imag(squeeze(Q(:,:,1,1))));
subplot(2,3,2)
mesh(X,Y,imag(squeeze(Q(:,:,2,1))));
subplot(2,3,3)
mesh(X,Y,imag(squeeze(Q(:,:,3,1))));
subplot(2,3,4)
mesh(X,Y,imag(squeeze(Q(:,:,1,2))));
subplot(2,3,5)
mesh(X,Y,imag(squeeze(Q(:,:,2,2))));
subplot(2,3,6)
mesh(X,Y,imag(squeeze(Q(:,:,3,2))));
pause;
subplot(2,3,1)
mesh(X,Y,abs(squeeze(Q(:,:,1,1))));
subplot(2,3,2)
mesh(X,Y,abs(squeeze(Q(:,:,2,1))));
subplot(2,3,3)
mesh(X,Y,abs(squeeze(Q(:,:,3,1))));
subplot(2,3,4)
mesh(X,Y,abs(squeeze(Q(:,:,1,2))));
subplot(2,3,5)
mesh(X,Y,abs(squeeze(Q(:,:,2,2))));
subplot(2,3,6)
mesh(X,Y,abs(squeeze(Q(:,:,3,2))));
pause;
subplot(2,3,1)
mesh(X,Y,real(squeeze(Q(:,:,1,2))));
subplot(2,3,2)
mesh(X,Y,real(squeeze(Q(:,:,2,2))));
subplot(2,3,3)
mesh(X,Y,real(squeeze(Q(:,:,3,2))));
subplot(2,3,4)
mesh(X,Y,imag(squeeze(Q(:,:,1,2))));
subplot(2,3,5)
mesh(X,Y,imag(squeeze(Q(:,:,2,2))));
subplot(2,3,6)
mesh(X,Y,imag(squeeze(Q(:,:,3,2))));
colormap(gray)
