 % chap4_2.m
% program implements the 2D angular spectrum expansion for forward and back
% propagation
% used to produce figs 4.4-4.8 in chapter 4
% created by ajd oct 31, 2006, modified march 2008, April 2011
clear all;
% use wavelength of unity
lambda=1;
% compute wavenumber
k=2*pi/lambda;
% select spacing sampling interval delx=lambda/Nx;
Nx=12;
delx=lambda/Nx;
% select total number of points in ffts
N=2048;
x=delx*(0:N-1);
xx=x-N/2*delx;
%xdisp=xx(1:2:N);
xdisp=xx;
% delK=spatial frequency sampling interval
% delK*delx=2*pi/N=> delK=2*pi/(N*delx)=(Nx/N)*k
delK=2*pi/(N*delx);
K=delK*(0:N-1);
Kdisp=K-N/2*delK;
x=repmat(xx.',1,N);
xp=repmat(xx,N,1);
% set up boundary value field on the z=0 plane
% select boundary value field to be contained within a slit of width 2a centered on the z=0
% plane
% input slit width in number of wavelengths
w=input('input slit width in number of wavelengths: width=  ');
a=w/2*lambda;
Na=round(a/delx);
psi_0=zeros(1,N);
%  psi_0(N/2-Na:N/2+Na)=tukeywin(2*Na+1);
 psi_0(N/2-Na:N/2+Na)=1;
%psi_0=sin(.1*k*x).*psi_0;
% 
% max z=(max gamma)*a/(10*delK)
zmax=sqrt(k^2-(2*pi/a)^2)*a/(10*delK)
% compute angular spectrum A(K)
A=fft(psi_0);
% compute free space filter exp(i*gamma*z)
gamma=zeros(1,N);
%Nmax=round(k/delK);
%gamma(1:Nmax)=sqrt(k^2-K(1:Nmax).^2);
gamma=sqrt(k^2-K.^2);
gamma(N:-1:N/2+2)=gamma(2:N/2);
% construct propagation filter
deltaz=50*lambda;
z=50*lambda;
for m=1:4;
    z=z+(m-1)*deltaz;
H=exp(i*gamma*z);
H(N/2+1)=0;
A_z=H.*A;
psi=ifft(A_z);
psi_z(:,m)=psi;
%%%%%%%
% now compute using Rayleigh Sommerfeld 
%%%%%%%
% Dirichlet Green function in 2D = 2 d H_0/dz' 
% G_D=2D Dirichlet Green function=ik/2H_1^+(kR)(z-z')/R
R=sqrt(z^2+(x-xp).^2);
% BESSELH(nu,Z)=H^+_{nu}(Z)
% compute NXN matrix representing G_D
GD=i*k/2*z./R.*besselh(1,k*R);
% compute diffracted field using simple matrix multiplication
chi=delx*GD*psi_0.';
%chi_z(:,m)=chi(1:2:N);
chi_z(:,m)=chi;
end;
xdisp_z=xdisp(1:4:N);
psi_zp=psi_z(1:4:N,:);
clf;
subplot(2,2,1);
h1=plot(xdisp_z,abs(psi_zp(:,1)),'k.-',xdisp,abs(chi_z(:,1)),'-k');
hlab1=xlabel('position in number of wavelengths');
ha1=gca;
subplot(2,2,2);
h2=plot(xdisp_z,abs(psi_zp(:,2)),'k.-',xdisp,abs(chi_z(:,2)),'-k');
hlab2=xlabel('position in number of wavelengths');
ha2=gca;
subplot(2,2,3);
h3=plot(xdisp_z,abs(psi_zp(:,3)),'k.-',xdisp,abs(chi_z(:,3)),'-k');
hlab3=xlabel('position in number of wavelengths');
ha3=gca;
subplot(2,2,4);
h4=plot(xdisp_z,abs(psi_zp(:,4)),'k.-',xdisp,abs(chi_z(:,4)),'-k');
hlab4=xlabel('position in number of wavelengths');
ha4=gca;
set(h1,'linewidth',1 ,'color',[0 0 0]);
set(h2,'linewidth',1 ,'color',[0 0 0]);
set(ha1,'linewidth',1.25,'FontSize',13);
set(ha2,'linewidth',1.25,'fontsize',13);
set(h3,'linewidth',1 ,'color',[0 0 0]);
set(h4,'linewidth',1 ,'color',[0 0 0]);
set(ha3,'linewidth',1.25,'FontSize', 13);
set(ha4,'linewidth',1.25,'fontsize',13);
set(hlab1,'fontsize',12);
set(hlab2,'fontsize',12);
set(hlab3,'fontsize',12);
set(hlab4,'fontsize',12);
pause;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% implement back propgation using angular spectrum
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
psi_tilde=fft(chi_z);
z=50*lambda;
for m=1:4;
    z=z+(m-1)*deltaz;
H=exp(-i*conj(gamma)*z);
H(N/2+1)=0;
A_z=H.'.*psi_tilde(:,m);;
psi_bp(:,m)=ifft(A_z);
end; 
clf;
subplot(2,1,1)
h1=plot(xdisp,abs(psi_bp(:,1)),'k-',xdisp,abs(chi_z(:,1)),'k-',xdisp,abs(psi_0),'k-');
hlab1=xlabel('position in number of wavelengths');
ha1=gca;
subplot(2,1,2);
ha2=gca;
h2=plot(xdisp,abs(psi_bp(:,2)),'k-',xdisp,abs(chi_z(:,2)),'k-',xdisp,abs(psi_0),'k-');
hlab2=xlabel('position in number of wavelengths');
set(h1,'linewidth',1.5 ,'color',[0 0 0]);
set(h2,'linewidth',1.5 ,'color',[0 0 0]);
set(ha1,'linewidth',1.25,'FontSize',13);
set(ha2,'linewidth',1.25,'fontsize',13);
set(hlab1,'fontsize',12);
set(hlab2,'fontsize',12);
