 % chap4_3.m
 % modification of fresnel2.m 
% program implements the 2D Fresnel transformation for forward and back
% propagation
% modification of fresnel1.m
% created by ajd November, 2006, modified april 2008 and april 2011
% generates fig.4.10 in chapter 4 of book
clear all;
% use wavelength of unity
lambda=1;
% compute wavenumber
k=2*pi/lambda;
% select spacing sampling interval delx=lambda/Nx;
Nx=8;
delx=lambda/Nx;
% select total number of points in arrays
N=1024;
x=delx*(0:N-1);
xdisp=x-N/2*delx;
% K=transform variable=k/z x with x=observation plane coordinate
% delK=spatial frequency sampling interval
% delK*delx=2*pi/N=> delK=2*pi/(N*delx)=(Nx/N)*k
delK=2*pi/(N*delx);
K=delK*(0:N-1);
Kdisp=K-N/2*delK;
% set up boundary value field on the z=0 plane
% select boundary value field to be contained within a slit of width 2a centered on the z=0
% plane
% input slit width in number of wavelengths
w=input('input slit width in number of wavelengths: width=  ');
a=w/2*lambda;
Na=round(a/delx);
psi_0=zeros(1,N);
% psi_0(N/2-Na:N/2+Na)=tukeywin(2*Na+1);
psi_0(N/2-Na:N/2+Na)=1;
% psi_0=sin(.1*k*x).*psi_0;
% loop over propagation distances
deltaz=10*lambda;
z=10*lambda;
for m=1:4;
z=z+(m-1)*deltaz;
% exact RS Dirichlet Green function=GD=i*k/2*z./R.*besselh(1,k*R)
% use Fresnel approximation: R~z-(x-x')^2/(2z)
% 
% set up boundary value field for Fresnel transformation
% F=exp(ik/2z x^2) psi_0
F=exp(i*k/(2*z)*xdisp.^2).*psi_0;
F=fftshift(F);
% compute FFT
A=i*k*delx*sqrt(1/(2*pi*k*z))*exp(i*k*z-i*3*pi/4)*fft(F);
% compute propagated field via Fresnel transform
% first compute x array at z
xz=z/k*Kdisp;
%GD=i*k/2*z./R.*besselh(1,k*R)~i*k/2*sqrt(2/pi k z);
psi_z(:,m)=exp(i*k*xz.*xz/(2*z)).*fftshift(A);
%%%%%%%
% now compute using exact Rayleigh Sommerfeld 
%%%%%%%
% Dirichlet Green function in 2D = 2 d H_0/dz' 
% G_D=2D Dirichlet Green function=ik/2H_1^+(kR)(z-z')/R
xa=xz;
%x=repmat(xdisp.',1,N);
x=repmat(xa.',1,N);
xp=repmat(xdisp,N,1);
R=sqrt(z^2+(x-xp).^2);
% BESSELH(nu,Z)=H^+_{nu}(Z)
% compute NXN matrix representing G_D
GD=i*k/2*z./R.*besselh(1,k*R);
% compute diffracted field using simple matrix multiplication
chi_z(:,m)=delx*GD*psi_0.';
end;
M1=N/2-50;M2=N/2+50;
psi_d=psi_z(M1:M2,:);
chi_d=chi_z(M1:M2,:);
xd=xz(M1:M2);
subplot(4,1,1)
plot(xd,abs(psi_d(:,1)),'k.',xd,abs(chi_d(:,1)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,2);
plot(xd,abs(psi_d(:,2)),'k.',xd,abs(chi_d(:,2)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,3)
plot(xd,abs(psi_d(:,3)),'k.',xd,abs(chi_d(:,3)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,4);
plot(xd,abs(psi_d(:,4)),'k.',xd,abs(chi_d(:,4)),'-k');
xlabel('position in number of wavelengths');
pause;
subplot(4,1,1)
plot(xd,real(psi_d(:,1)),'k.',xd,real(chi_d(:,1)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,2);
plot(xd,real(psi_d(:,2)),'k.',xd,real(chi_d(:,2)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,3)
plot(xd,real(psi_d(:,3)),'k.',xd,real(chi_d(:,3)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,4);
plot(xd,real(psi_d(:,4)),'k.',xd,real(chi_d(:,4)),'-k');
xlabel('position in number of wavelengths');
pause;
subplot(4,1,1)
plot(xd,imag(psi_d(:,1)),'k.',xd,imag(chi_d(:,1)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,2);
plot(xd,imag(psi_d(:,2)),'k.',xd,imag(chi_d(:,2)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,3)
plot(xd,imag(psi_d(:,3)),'k.',xd,imag(chi_d(:,3)),'-k');
xlabel('position in number of wavelengths');
subplot(4,1,4);
plot(xd,imag(psi_d(:,4)),'k.',xd,imag(chi_d(:,4)),'-k');
xlabel('position in number of wavelengths');
pause;
%
% replot
%
subplot(4,2,1)
plot(xd,real(psi_d(:,1)),'k.',xd,real(chi_d(:,1)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,2);
plot(xd,real(psi_d(:,2)),'k.',xd,real(chi_d(:,2)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,3)
plot(xd,real(psi_d(:,3)),'k.',xd,real(chi_d(:,3)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,4);
plot(xd,real(psi_d(:,4)),'k.',xd,real(chi_d(:,4)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,5)
plot(xd,imag(psi_d(:,1)),'k.',xd,imag(chi_d(:,1)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,6);
plot(xd,imag(psi_d(:,2)),'k.',xd,imag(chi_d(:,2)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,7)
plot(xd,imag(psi_d(:,3)),'k.',xd,imag(chi_d(:,3)),'-k');
xlabel('position in number of wavelengths');
subplot(4,2,8);
plot(xd,imag(psi_d(:,4)),'k.',xd,imag(chi_d(:,4)),'-k');
xlabel('position in number of wavelengths');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Implement Inverse Fresnel Transformation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% deltaz=100*lambda;
% z=100*lambda;
% for m=1:4;
% z=z+(m-1)*deltaz;
% xz=z/k*Kdisp;
% % demodulate field at z
% %
% Ftil=1./(i*k*delx*sqrt(1/(2*pi*k*z))*exp(i*k*z-i*3*pi/4)).*exp(-i*k*xz.*xz/(2*z)).*chi_z(:,m).';
% Ftilf=1./(i*k*delx*sqrt(1/(2*pi*k*z))*exp(i*k*z-i*3*pi/4)).*exp(-i*k*xz.*xz/(2*z)).*psi_z(:,m).';
% Ftil=fftshift(Ftil);
% F=fftshift(ifft(Ftil));
% Ftilf=fftshift(Ftilf);
% Ff=fftshift(ifft(Ftilf));
% phi_0(:,m)=exp(-i*k/(2*z)*xdisp.^2).*F;
% phi_0f(:,m)=exp(-i*k/(2*z)*xdisp.^2).*Ff;
% phi_d=phi_0(M1:M2,:);
% phi_df=phi_0f(M1:M2,:);
% psi_d=psi_0(M1:M2);
% end;
% clf;
% subplot(4,1,1)
% plot(xdisp,abs(phi_0(:,1)),'k.-',xdisp,abs(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,2);
% plot(xdisp,abs(phi_0(:,2)),'k.-',xdisp,abs(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,3)
% plot(xdisp,abs(phi_0(:,3)),'k.-',xdisp,abs(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,4);
% plot(xdisp,abs(phi_0(:,4)),'k.-',xdisp,abs(psi_0),'k-');
% xlabel('position in number of wavelengths');
% pause;
% subplot(4,1,1)
% plot(xdisp,real(phi_0(:,1)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,2);
% plot(xdisp,real(phi_0(:,2)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,3)
% plot(xdisp,real(phi_0(:,3)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,4);
% plot(xdisp,real(phi_0(:,4)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% pause;
% subplot(4,1,1)
% plot(xdisp,imag(phi_0(:,1)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,2);
% plot(xdisp,imag(phi_0(:,2)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,3)
% plot(xdisp,imag(phi_0(:,3)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,4);
% plot(xdisp,imag(phi_0(:,4)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% pause;
% subplot(4,1,1)
% plot(xdisp,real(phi_0f(:,1)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,2);
% plot(xdisp,real(phi_0f(:,2)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,3)
% plot(xdisp,real(phi_0f(:,3)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,4);
% plot(xdisp,real(phi_0f(:,4)),'k.-',xdisp,real(psi_0),'k-');
% xlabel('position in number of wavelengths');
% pause;
% subplot(4,1,1)
% plot(xdisp,imag(phi_0f(:,1)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,2);
% plot(xdisp,imag(phi_0f(:,2)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,3)
% plot(xdisp,imag(phi_0f(:,3)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');
% subplot(4,1,4);
% plot(xdisp,imag(phi_0f(:,4)),'k.-',xdisp,imag(psi_0),'k-');
% xlabel('position in number of wavelengths');













