% program chap5_1.m
% program computes and plots singular values ratio of sigma_l to h_l
% illustrating stability of 2D ISP
% generates fig5.1 in book
clear all;
L=(1:100);
ka=(10:20:90);
mtemp=repmat((pi./(2*ka)).',1,100);
temp=besselj(L+1/2,ka.').^2-besselj(L-1/2,ka.').*besselj(L+3/2,ka.');
mu1=mtemp.*abs(temp);
maxx=max(mu1.');
maxx=repmat(maxx,100,1);
mu1n=mu1.'./maxx;
% now compute H_l(ka)
temp=besselh(L+1/2,ka.');
mu2=mtemp.*(temp.*conj(temp));
maxx=max(mu2.');
maxx=repmat(maxx,100,1);
mu2n=mu2.'./maxx;
clf;
subplot(2,1,1)
h1=plot(L,mu1n,'-k');
hlabx1=xlabel('index n');
hlaby1=ylabel('normalized  \mu_n^2 ');
ha1=gca;
grid;
%legend('ka=10','ka=30','ka=50','ka=70','ka=90');
 subplot(2,1,2);
h2=semilogy(L,mu1n,'-k');
hlabx2=xlabel('index n');
hlaby2=ylabel('log  \mu_n^2 ');
ha2=gca;
grid;
%legend('ka=10','ka=30','ka=50','ka=70','ka=90');
set(h1,'linewidth',1.5,'color',[0 0 0]);
set(h2,'linewidth',1.5,'color',[0 0 0]);
set(ha1,'linewidth',1.25,'FontSize', 13);
set(ha2,'linewidth',1.25,'fontsize',13);
set(hlabx1,'fontsize',13);
set(hlabx2,'fontsize',13);
set(hlaby1,'fontsize',13);
set(hlaby2,'fontsize',13);



