% program chap5_2.m
% program computes and plots  bessel functions illustrating overall
% behavior
% generates fig. 5.2 in chapter 5 of book
%
% user must respond click on plot to label the different curves as done in
% fig. 5.2 or program will not function properly.
clear all;
N=400;
L=[3,6,9,12];
x0=0;
delx=.04;
x=x0+delx*[1:N];
n=0;
L0=0;

for l=L;
    n=n+1;
    f(n,:)=besselj(l,x);
    fp(n,:)=f(n,:)./max(f(n,:));
end;
clf;
% h1=plot(x,fp.');
% hlabx1=xlabel('argument x');
% hlaby1=ylabel('J_l(x) normalized');
% ha1=gca;
% grid;
% set(h1,'linewidth',1.5,'color',[0 0 0]);
% set(ha1,'linewidth',1.25,'FontSize', 13);
% set(hlabx1,'fontsize',13);
% set(hlaby1,'fontsize',13);
% pause;
h2=plot(x,f.');
ha2=gca;
hlabx2=xlabel('argument x');
hlaby2=ylabel('J_l(x) ');
grid;
set(h2,'linewidth',1.5,'color',[0 0 0]);
set(ha2,'linewidth',1.25,'fontsize',13);
set(hlabx2,'fontsize',13);
set(hlaby2,'fontsize',13);
%
hline=get(ha2,'children');
% set(hline(3),'linewidth',1.5,'linestyle','-','marker','o');
% set(hline(4),'linewidth',1.5,'linestyle','-','marker','x');
% set(hline(1),'linewidth',1.5,'linestyle','-','marker','*');
% set(hline(2),'linewidth',1.5,'linestyle','-','marker','+');
set(ha2,'fontsize',13,'xminortick','on')
set(hline(3),'linewidth',1.5,'linestyle','-');
set(hline(4),'linewidth',1.5,'linestyle','-');
set(hline(1),'linewidth',1.5,'linestyle','-');
set(hline(2),'linewidth',1.5,'linestyle','-');
hg1=gtext('J_3(x)');
hg2=gtext('J_6(x)');
hg3=gtext('J_9(x)');
hg4=gtext('J_{12}(x)');
set(hg1,'fontsize',13);
set(hg2,'fontsize',13);
set(hg3,'fontsize',13);
set(hg4,'fontsize',13);
