% program chap5_3.m
% program computes and plots  component 2D sources for 2D ISP
% behavior
% generates fig.5.3 in chapter 5 of book.
%
clear all;
% unit wavelength
lambda=1;
k=2*pi/lambda;
Nphi=360;
delphi=2*pi/Nphi;
L=[10,20,30,40];
a_0=L(4)/k;
r0=0;
delr=lambda/16;
N=a_0/delr;
r=r0+delr*[1:N];
x=k*r;
% angles
phi=delphi*[0:Nphi-1].';
n=0;
L0=0;
% construct component sources
for l=L;
    n=n+1;
    S(:,:,n)=exp(i*l*phi)*besselj(l,x);
end;
[Phi,R]=ndgrid(phi.',r);
[x,y]=pol2cart(Phi,R);
clf;
subplot(2,2,1)
mesh(x,y,abs(S(:,:,1)));
axis image;
axis off;
view(2);
subplot(2,2,2)
mesh(x,y,abs(S(:,:,2)));
axis equal;
axis off;
view(2);
subplot(2,2,3)
mesh(x,y,abs(S(:,:,3)));
axis equal;
axis off;
view(2);
subplot(2,2,4)
mesh(x,y,abs(S(:,:,4)));
axis equal;
axis off;
view(2);
colormap(gray);
pause;
subplot(2,2,1)
mesh(x,y,real(S(:,:,1)));
axis image;
axis off;
view(2);
subplot(2,2,2)
mesh(x,y,real(S(:,:,2)));
axis equal;
axis off;
view(2);
subplot(2,2,3)
mesh(x,y,real(S(:,:,3)));
axis equal;
axis off;
view(2);
subplot(2,2,4)
mesh(x,y,real(S(:,:,4)));
axis equal;
axis off;
view(2);
colormap(gray);
pause;
subplot(2,2,1)
contour(x,y,real(S(:,:,1)));
axis equal;
subplot(2,2,2)
contour(x,y,real(S(:,:,2)));
axis equal;
subplot(2,2,3)
contour(x,y,real(S(:,:,3)));
axis equal;
subplot(2,2,4)
contour(x,y,real(S(:,:,4)));
axis equal
pause;
