% program chap5_4.m
% modification of chap7_4.m
% program computes and plots  2D PSF
% program created by AJD 2008, modified april 2011
% generates fig.5.4 in chapter 5 of book.
clear all;
% unit wavelength
lambda=1;
k=2*pi/lambda;
Nphi=360;
delphi=2*pi/Nphi;
%Lmax=24;
Lmax=34;
L=[1:Lmax];
a_0=24/k;
ka0=round(k*a_0);
delr=lambda/16;
N=round(a_0/delr);
r=delr*[0:N-1];
x=k*r;
Nrp=4;
delrp=a_0/(Nrp-1);
% angles
phi=delphi*[0:Nphi-1].';
L0=0;
S=zeros(Nphi,N,Nrp);
% construct singular values
mu=besselj(L,ka0).^2-2*L./ka0.*besselj(L,ka0).*besselj(L+1,ka0)+besselj(L+1,ka0).^2;
mu0=besselj(0,ka0).^2+besselj(1,ka0).^2;
% construct component sources
for n=1:Nrp;
    xp=k*(n-1)*delrp;
for l=L;
       S(:,:,n)=S(:,:,n)+cos(l*phi)*besselj(l,x).*besselj(l,xp)./mu(l);
end;
S(:,:,n)=S(:,:,n)+.5*ones(Nphi,1)*besselj(0,x).*besselj(0,xp)./mu0;
end;
[Phi,R]=ndgrid(phi.',r);
[x,y]=pol2cart(Phi,R);
%%%%%%%%%%%%%%%%%%%%
clf;
subplot(1,2,1)
mesh(x,y,abs(S(:,:,1)));
axis image;
axis off;
view(0,90);
colorbar;
colormap(jet);
subplot(1,2,2)
mesh(x,y,abs(S(:,:,3)));
axis equal;
axis off;
view(0,90);
colorbar;
colormap(jet)
pause;
%%%%
%%%%%%%%%%%%%%%%%%%%
clf;
subplot(1,2,1)
mesh(x,y,abs(S(:,:,1)));
axis image;
axis off;
view(-25,75);
colorbar;
colormap(jet);
subplot(1,2,2)
mesh(x,y,abs(S(:,:,3)));
axis equal;
axis off;
view(-25,75);
colorbar;
colormap(gray)
pause;
%%%%
subplot(2,2,1)
mesh(x,y,abs(S(:,:,1)));
axis image;
axis off;
view(0,90);
colorbar;
subplot(2,2,2)
mesh(x,y,abs(S(:,:,2)));
axis equal;
axis off;
view(0,90);
colorbar;
subplot(2,2,3)
mesh(x,y,abs(S(:,:,3)));
axis equal;
axis off;
view(0,90);
colorbar;
subplot(2,2,4)
mesh(x,y,abs(S(:,:,4)));
axis equal;
axis off;
view(0,90);
colorbar;
colormap(jet)
pause;
%%%%
clf;
subplot(1,3,1)
mesh(x,y,abs(S(:,:,1)));
axis image;
axis off;
view(-25,70);
%colorbar;
subplot(1,3,2)
mesh(x,y,abs(S(:,:,2)));
axis equal;
axis off;
view(-25,70);
%colorbar;
subplot(1,3,3)
mesh(x,y,abs(S(:,:,3)));
axis equal;
axis off;
view(-25,70)
%colorbar;
colormap(gray)
pause;
subplot(2,2,1)
mesh(x,y,abs(S(:,:,1)));
axis image;
axis off;
view(-25,75);
colorbar;
subplot(2,2,2)
mesh(x,y,abs(S(:,:,2)));
axis equal;
axis off;
view(-25,75);
colorbar;
subplot(2,2,3)
mesh(x,y,abs(S(:,:,3)));
axis equal;
axis off;
view(-25,75);
colorbar;
subplot(2,2,4)
mesh(x,y,abs(S(:,:,4)));
axis equal;
axis off;
view(-25,75);
colorbar;
colormap(gray)
pause;
subplot(2,2,1)
contour(x,y,abs(S(:,:,1)));
axis image;
axis off;
colorbar;
subplot(2,2,2)
contour(x,y,abs(S(:,:,2)));
axis equal;
axis off;
colorbar;
subplot(2,2,3)
contour(x,y,abs(S(:,:,3)));
axis equal;
axis off;
colorbar;
subplot(2,2,4)
contour(x,y,abs(S(:,:,4)));
axis equal;
axis off;
colorbar;
colormap(gray)
pause;
subplot(2,2,1)
contour(x,y,real(S(:,:,1)));
axis image;
axis off;
colorbar;
subplot(2,2,2)
contour(x,y,real(S(:,:,2)));
axis equal;
axis off;
colorbar;
subplot(2,2,3)
contour(x,y,real(S(:,:,3)));
axis equal;
axis off;
colorbar;
subplot(2,2,4)
contour(x,y,real(S(:,:,4)));
axis equal;
axis off;
colorbar;
colormap(gray)



