% program chap5_5.m
% modification of chap7_7.m
% by AJD april 2011
% program computes and plots  the super-resolved ME source for 2D scalar wavelet field
% also computes rad pattern via numerical Fourier transform of wavelet
% source
% generates fig. 5.5 in chapter 5 of book
%
clear all;
% unit wavelength
lambda=1;
k=2*pi/lambda;
Nphi=800;
delphi=2*pi/Nphi;
a_0=10*lambda;
ka0=round(k*a_0);
Lmax=3*ka0;
L=[1:Lmax];
delr=lambda/16;
N=round(a_0/delr)+1;
r=delr*[0:N-1];
x=k*r;
% angles
phi=delphi*[0:Nphi-1].';
L0=0;
S=zeros(Nphi,N);
% wavelet parameter  
a=a_0;
% plot idealized and actual radiation patterns
frad1=exp(k*a*cos(phi))./exp(k*a);
%
% construct singular values
mu=a_0^2/2*(besselj(L,ka0).^2-2*L./ka0.*besselj(L,ka0).*besselj(L+1,ka0)+besselj(L+1,ka0).^2);
mu0=a_0^2/2*(besselj(0,ka0).^2+besselj(1,ka0).^2);
% construct source
xp=i*k*a;
frad2=zeros(Nphi,1);
for l=L;
    frad2=frad2+(-i)^l.*cos(l*phi).*besselj(l,xp);
    S(:,:)=S(:,:)+cos(l*phi)*besselj(l,x).*besselj(l,xp)./mu(l);
end;
S(:,:)=S(:,:)+.5*ones(Nphi,1)*besselj(0,x).*besselj(0,xp)./mu0;
S(:,:)=sqrt(8*k/pi)*exp(i*3*pi/4)*S(:,:)./(exp(k*a));
frad2=frad2+.5*besselj(0,xp);
frad2=2*frad2./exp(k*a);
[Phi,R]=ndgrid(phi.',r);
[x,y]=pol2cart(Phi,R);
%%%%%%%%%%%%%%%%%%%%
phirange=(Nphi/2-100:Nphi/2+100);
phip=[-pi:delphi:pi];
phiplt=phip(phirange);
f1p=fftshift(frad1);
frad1plt=f1p(phirange);
f2p=fftshift(frad2);
frad2plt=f2p(phirange);
subplot(1,2,1)
plot(phiplt,frad1plt,'k-',phiplt,real(frad2plt),'r.');
title('Wavelet Radiation Patterns')
xlabel('angle in radians');
subplot(1,2,2)
mesh(x,y,abs(S(:,:)));
title('Absolute Value of Wavelet Source');
axis image;
axis off;
view(0,90);
colorbar;
colormap(gray);
pause;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
subplot(1,2,1)
mesh(x,y,real(S(:,:)));
%title('Real Part of Wavelet Source');
axis image;
axis off;
view(0,90);
colorbar;
colormap(gray);
subplot(1,2,2)
mesh(x,y,real(S(:,:)));
title('Real Part of Wavelet Source');
axis image;
axis off;
view(-40,120);
colorbar;
colormap(gray);
pause;
clf;
% magnify by 10 to aid viewing
subplot(1,2,1)
mesh(x,y,10*real(S(:,:)));
title('Real Part of Wavelet Source');
axis image;
axis off;
view(-45,45);
colorbar;
colormap(gray);
subplot(1,2,2)
mesh(x,y,10*abs(S(:,:)));
title('Magnitude of Wavelet Source');
axis image;
axis off;
view(-45,45);
colorbar;
colormap(gray);
pause;
% magnify by 10 to aid viewing
subplot(1,3,1)
mesh(x,y,10*real(S));
title('Real Part of Wavelet Source');
axis image;
axis off;
view(-45,45);
%colorbar;
subplot(1,3,2)
mesh(x,y,10*imag(S));
title('Imaginary Part of Wavelet Source');
axis image;
axis off;
view(-45,45);
%colorbar;
colormap(gray);
subplot(1,3,3)
mesh(x,y,10*abs(S));
title('Magnitude of Wavelet Source');
axis image;
axis off;
view(-45,45);
colormap(gray);
%colorbar;
pause;
clf;
Ntheta=100;
deltheta=pi/Ntheta;
out=zeros(Ntheta,1);
theta=deltheta*[1:Ntheta]-pi/2;
Theta=repmat(theta.',1,Nphi);
Phi=repmat(phi.',Ntheta,1);
for nr=1:N;   
H=r(nr)*exp(-i*k*r(nr)*cos(Theta-Phi));
out=out+H*S(:,nr);
end;
% rad pattern
out0= -i/4.*sqrt(2/(k*pi))*exp(-i*pi/4).*out*delphi*delr;
frad3=exp(k*a*cos(theta))./exp(k*a);
clf;
plot(theta,real(out0),'k-',theta,frad3,'r.');
title('Radiation Pattern and Computed Radiation Pattern from Source');
xlabel('Polar Angle in Radians');

 