% program chap6_2.m
% modification of program cylscat2.m
% this program computes the exact abd born approximations of the scattering amplitude of a
% penetrable cylinder at fixed  wavenumber and four different
% indicies of refraction of the cylinder
%
% based on the theory developed in chapter 6 of book
% generates figs. 6.4 and 6.5 in book.
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of cylinder a0
a0=4*lambda0;
% max l=k00*a0;
L=round(k00*a0)+20;
% set  n of cylinder
nc=[1.01,1.03,1.05,1.07];
k0=k00; 
% set up angles to compute scattering amplitude
Nalpha=200;
delalpha=pi/(2*Nalpha);
alpha=delalpha*[-Nalpha/2:Nalpha/2-1];
alpha0=0;
% 
% loop over cylinder indicies
% 
for ncount=1:4;
    ncyl=nc(ncount);
    k=k0*ncyl;
% loop over bessel indicies l
    % highest index = k0*a0
         for l=1:L;
             ll=l-1;           
    % compute transmission coefficient from chap 8
     denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
     numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
     mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
     end;
% compute transmission function
T=2*i/(pi*k0*a0)./(denom+eps);
% T(nf,ni,l) argument=#frequencies, # indicies, index # of bessel functions
R=numer./(denom+eps);
%
% compute scattering amplitudes as function of angle
%
for na=1:Nalpha;
    fs=0;fsb=0;
    for l=2:L;
        fs=fs+R(l)*cos(l*(alpha(na)-alpha0));
        fsb=fsb+mu0(l)*cos(l*(alpha(na)-alpha0));
    end;
    fscat(na,ncount)=sqrt(2/(pi*k0))*exp(-i*pi/4)*(R(1)+2*fs);
    fsborn(na,ncount)=-sqrt(pi/(2*k0))*exp(i*pi/4)*k0^2*(1-ncyl^2)*(mu0(1)+2*fsb);
end;
norm=max(abs(fscat(:,ncount)));
fscatn(:,ncount)=abs(fscat(:,ncount));
normb=max(abs(fsborn(:,ncount)));
fsbornn(:,ncount)=abs(fsborn(:,ncount));
arge(:,ncount)=(angle(fscat(:,ncount)));
argb(:,ncount)=(angle(fsborn(:,ncount)));
end;
%
% plot results
%
subplot(2,2,1)
plot(alpha,fscatn(:,1),'k-',alpha,fsbornn(:,1),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,fscatn(:,2),'k-',alpha,fsbornn(:,2),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,fscatn(:,3),'k-',alpha,fsbornn(:,3),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,fscatn(:,4),'k-',alpha,fsbornn(:,4),'k:');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,arge(:,1),'k-',alpha,argb(:,1),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,arge(:,2),'k-',alpha,argb(:,2),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,arge(:,3),'k-',alpha,argb(:,3),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,arge(:,4),'k-',alpha,argb(:,4),'k:');
xlabel('angle');
% pause;
% clf;
% subplot(2,2,1)
% plot(alpha,real(fscat(:,1)),'k-',alpha,real(fsborn(:,1)),'k:');
% xlabel('angle');
% subplot(2,2,2)
% plot(alpha,real(fscat(:,2)),'k-',alpha,real(fsborn(:,2)),'k:');
% xlabel('angle');
% subplot(2,2,3)
% plot(alpha,real(fscat(:,3)),'k-',alpha,real(fsborn(:,3)),'k:');
% xlabel('angle');
% subplot(2,2,4)
% plot(alpha,real(fscat(:,4)),'k-',alpha,real(fsborn(:,4)),'k:');
% xlabel('angle');
% pause;
% subplot(2,2,1)
% plot(alpha,imag(fscat(:,1)),'k-',alpha,imag(fsborn(:,1)),'k:');
% xlabel('angle');
% subplot(2,2,2)
% plot(alpha,imag(fscat(:,2)),'k-',alpha,imag(fsborn(:,2)),'k:');
% xlabel('angle');
% subplot(2,2,3)
% plot(alpha,imag(fscat(:,3)),'k-',alpha,imag(fsborn(:,3)),'k:');
% xlabel('angle');
% subplot(2,2,4)
% plot(alpha,imag(fscat(:,4)),'k-',alpha,imag(fsborn(:,4)),'k:');
% xlabel('angle');
% pause;
% 
% 
% 
