% program chap6_3.m
% modification of program cylscat3.m
% this program computes the scattering amplitude of a pair of concentric 
% penetrable cylinders at fixed  wavenumber and two different
% pairs of indicies of refraction of the cylinders as a function angle alpha
%
% based on the theory developed in chapter 6 of book
% generates figs 6.6 and 6.7 in chapter 6 of book.
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of inner cylinder a1
a1=2*lambda0;
% radius of outer cylinder a2
a2=4*lambda0;
% max l=k00*a2;
L=round(k00*a2);
% set  n1 of inner cylinder
nc1=[1.03,1.07];
% set  n2 of outer cylinder shell
nc2=[1.03,1.07];
k0=k00; 
% set up angles to compute scattering amplitude
Nalpha=200;
delalpha=pi/(2*Nalpha);
alpha=delalpha*[-Nalpha/2:Nalpha/2-1];
alpha0=0;
% 
% loop over cylinder indicies
% 
ncount=0;
for ncount1=1:2;
    ncyl1=nc1(ncount1);
    k1=k0*ncyl1;
    for ncount2=1:2;
        ncyl2=nc2(ncount2);
    k2=k0*ncyl2;
    ncount=1+ncount;
% loop over bessel indicies l
    % highest index = k0*a0
         for l=1:L;
             ll=l-1;           
    % compute matrix elements from chap 8
    row1=[-besselj(ll,k1*a1),besselj(ll,k2*a1),0,besselh(ll,k2*a1)];
    row2=[-ncyl1*besselder(ll,k1*a1,0),ncyl2*besselder(ll,k2*a1,0),0,ncyl2*besselder(ll,k2*a1,1)];
    row3=[0,besselj(ll,k2*a2),-besselh(ll,k0*a2),besselh(ll,k2*a2)];
    row4=[0,ncyl2*besselder(ll,k2*a2,0),-besselder(ll,k0*a2,1),ncyl2*besselder(ll,k2*a2,1)];
    H=[row1;row2;row3;row4];
    amp3=besselj(ll,k0*a2);
    amp4=besselder(ll,k0*a2,0);
    A0=[0;0;amp3;amp4];
    A(:,l)=inv(H)*A0; 
    % now do born
    mu1(l)= a1^2/2.*((besselj(ll,k0*a1)).^2-besselj(ll-1,k0*a1).*besselj(ll+1,k0*a1));
     mu2(l)= a2^2/2.*((besselj(ll,k0*a2)).^2-besselj(ll-1,k0*a2).*besselj(ll+1,k0*a2));
          end;
         %
% compute scattering amplitudes as function of angle
%
for na=1:Nalpha;
    fs=0;fsb1=0;fsb2=0;
    for l=2:L;             
        fs=fs+A(3,l)*cos(l*(alpha(na)-alpha0));
      fsb1=fsb1+mu1(l)*cos(l*(alpha(na)-alpha0));
      fsb2=fsb2+mu2(l)*cos(l*(alpha(na)-alpha0));
    end;
    fscat(na,ncount)=sqrt(2/(pi*k0))*exp(-i*pi/4)*(A(3,1)+2*fs);
   fsborn(na,ncount)=-sqrt(pi/(2*k0))*exp(i*pi/4)*(k0^2*(ncyl2^2-ncyl1^2)*(mu1(1)+2*fsb1)+k0^2*(1-ncyl2^2)*(mu1(2)+2*fsb2));
   ;
 end;
norm=max(abs(fscat(:,ncount)));
fscatn(:,ncount)=abs(fscat(:,ncount));
% normb=max(abs(fsborn(:,ncount)));
fsbornn(:,ncount)=abs(fsborn(:,ncount));
arge(:,ncount)=(angle(fscat(:,ncount)));
argb(:,ncount)=(angle(fsborn(:,ncount)));  
end;
end;
subplot(2,2,1)
plot(alpha,fscatn(:,1),'k-',alpha,fsbornn(:,1),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,fscatn(:,2),'k-',alpha,fsbornn(:,2),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,fscatn(:,3),'k-',alpha,fsbornn(:,3),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,fscatn(:,4),'k-',alpha,fsbornn(:,4),'k:');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,arge(:,1),'k-',alpha,argb(:,1),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,arge(:,2),'k-',alpha,argb(:,2),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,arge(:,3),'k-',alpha,argb(:,3),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,arge(:,4),'k-',alpha,argb(:,4),'k:');
xlabel('angle');
pause;
clf;
subplot(2,2,1)
plot(alpha,real(fscat(:,1)),'k-',alpha,real(fsborn(:,1)),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,real(fscat(:,2)),'k-',alpha,real(fsborn(:,2)),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,real(fscat(:,3)),'k-',alpha,real(fsborn(:,3)),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,real(fscat(:,4)),'k-',alpha,real(fsborn(:,4)),'k:');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,imag(fscat(:,1)),'k-',alpha,imag(fsborn(:,1)),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,imag(fscat(:,2)),'k-',alpha,imag(fsborn(:,2)),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,imag(fscat(:,3)),'k-',alpha,imag(fsborn(:,3)),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,imag(fscat(:,4)),'k-',alpha,imag(fsborn(:,4)),'k:');
xlabel('angle');
pause;





     
