% program chap6_4.m
% modification of  program cylscaterror.m
% this program computes the L^2 error between the exact and born scattering amplitudes of a
% penetrable cylinder at four different wavenumbers as a function relative
% indices of refraction
%
% based on the theory developed in chapter 6 of book
% program generates fig. 6.8 in book
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of cylinder a0
radius=lambda0*[1,2,3,4];
Nrad=length(radius);
% max l=k00*a0;
L=round(k00*radius(4))+20;
% set  n of cylinder
nc=[1.0:.01:1.1];
nrel=100*(nc-1);
Nc=length(nc);
k0=k00; 
% set up angles to compute scattering amplitude
Nalpha=400;
delalpha=2*pi/Nalpha;
alpha=delalpha*[-Nalpha/2:Nalpha/2-1];
alpha0=0;
% loop over cylinder radii
for nrad=1:Nrad;
    a0=radius(nrad);
% 
% loop over cylinder indicies
% 
for ncount=1:Nc;
    ncyl=nc(ncount);
    k=k0*ncyl;
% loop over bessel indicies l
    % highest index = k0*a0
         for l=1:L;
             ll=l-1;           
    % compute transmission coefficient from chap 8
     denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
     numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
     mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
     end;
R=numer./(denom+eps);
RB=-i*pi/2*k0^2*(1-ncyl^2)*mu0;
delR=R-RB;
%
% compute relative error
%
E(ncount,nrad)=100*(norm(R-RB)./(norm(R)+eps));
end;
end;
%
% plot results
%
subplot(2,1,1);
plot(nrel,E(:,1),'k-',nrel,E(:,2),'k-',nrel,E(:,3),'k-',nrel,E(:,4),'k-');
xlabel('relative index in percent');
ylabel('error in percent');
grid on
subplot(2,1,2);
plot(nrel*radius(1),E(:,1),'k-',nrel*radius(2),E(:,2),'k-',nrel*radius(3),E(:,3),'k-',nrel*radius(4),E(:,4),'k-');
xlabel('product of relative index in percent with radii');
ylabel('error in percent');
grid on

% 
% 
% 
