% program chap6_5.m
% modification of program bornrytov1.m
% modification of cylscat4.m
% this program computes the exact and born approximations of the field scattered
% by a penetrable cylinder at fixed  wavenumber and four different
% indicies of refraction of the cylinder
%
% based on the theory developed in chapter 6 of book
% generates figs 6.9 and 6.10 in chapter 6 of book.
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of cylinder a0
a0=4*lambda0;
% max l=k00*a0;
L=round(k00*a0)+20;
Ll=[0:L-1];
% set  n of cylinder
nc=[1.01,1.03,1.05,1.07];
k0=k00; 
% distance to measurement line
z0=a0+lambda0;
% x=r sin phi=z tan phi, 
%x0=z0*tan(pi/4);
x0=2*a0;
Nx=200;
delx=2*x0/Nx;
x=[-x0:delx:x0];
Nx=length(x);
% phi=atan(x/z0);
phi=atan(x/z0).';
% r=sqrt(x^2+z0^2)
kr=k0*sqrt(x.^2+z0^2).';
% 
% set up fast computation using array processing
%%%
% compute for l=0 to L-1
%
H1=2*cos(phi*Ll);
H1(:,1)=1;
H=besselh(Ll,kr).*H1;
%
% zero angle of incidence of plane wave
alpha0=0;
% 
% loop over cylinder indicies
% 
for ncount=1:4;
    ncyl=nc(ncount);
    k=k0*ncyl;
% loop over bessel indicies l
    % highest index =L-1
         for l=1:L;
             ll=l-1;           
    % compute transmission coefficient from chap 8
     denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
     numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
     mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
     end;
R=numer./(denom+eps);
% Born reflection coefficient
RB=-i*pi/2*k0^2*(1-ncyl^2)*mu0;
%
% compute scattered field over line located at z0
%
%  perform computation using array processing
%
% use results from chap 8 on born scat from cylinder
%
% exact
% 
bl=i.^(Ll).*R;
% Born
blB=i.^(Ll).*RB;
%
% compute scattered field over line at l0
%
U(:,ncount)=H*bl.';
Ub(:,ncount)=H*blB.';
end;
%
% plot results
%
% subplot(2,2,1)
% plot(x,abs(U(:,1)),'k-',x,abs(Ub(:,1)),'k:');
% xlabel('x');
% subplot(2,2,2)
% plot(x,abs(U(:,2)),'k-',x,abs(Ub(:,2)),'k:');
% xlabel('x');
% subplot(2,2,3)
% plot(x,abs(U(:,3)),'k-',x,abs(Ub(:,3)),'k:');
% xlabel('x');
% subplot(2,2,4)
% plot(x,abs(U(:,4)),'k-',x,abs(Ub(:,4)),'k:');
% xlabel('x');
% pause;
% subplot(2,2,1)
% plot(x,unwrap(angle(U(:,1))),'k-',x,unwrap(angle(Ub(:,1))),':k');
% xlabel('x');
% subplot(2,2,2)
% plot(x,unwrap(angle(U(:,2))),'k-',x,unwrap(angle(Ub(:,2))),':k');
% xlabel('x');
% subplot(2,2,3)
% plot(x,unwrap(angle(U(:,3))),'k-',x,unwrap(angle(Ub(:,3))),':k');
% xlabel('x');
% subplot(2,2,4)
% plot(x,unwrap(angle(U(:,4))),'k-',x,unwrap(angle(Ub(:,4))),':k');
% xlabel('x');
% pause;
%
% compute exact, born and Rytov  total fields over measurement line
% Ut, Ubt, and UR=total fields
%U=exp(i*k0*z0)+U;
 phirytov=z0-i/k0*exp(-i*k0*z0)*Ub;
%Ub=exp(i*k0*z0)+Ub;
 UR=exp(i*k0*phirytov)-exp(i*k0*z0);
subplot(2,2,1)
plot(x,abs(UR(:,1)),'k--',x,abs(U(:,1)),'k-',x,abs(Ub(:,1)),':k');
xlabel('x');
subplot(2,2,2)
plot(x,abs(UR(:,2)),'k--',x,abs(U(:,2)),'k-',x,abs(Ub(:,2)),':k');
xlabel('x');
subplot(2,2,3)
plot(x,abs(UR(:,3)),'k--',x,abs(U(:,3)),'k-',x,abs(Ub(:,3)),':k');
xlabel('x');
subplot(2,2,4)
plot(x,abs(UR(:,4)),'k--',x,abs(U(:,4)),'k-',x,abs(Ub(:,4)),':k');
xlabel('x');
pause;
subplot(2,2,1)
plot(x,unwrap(angle(UR(:,1))),'k--',x,unwrap(angle(U(:,1))),'k-',x,unwrap(angle(Ub(:,1))),':k');
xlabel('x');
subplot(2,2,2)
plot(x,unwrap(angle(UR(:,2))),'k--',x,unwrap(angle(U(:,2))),'k-',x,unwrap(angle(Ub(:,2))),':k');
xlabel('x');
subplot(2,2,3)
plot(x,unwrap(angle(UR(:,3))),'k--',x,unwrap(angle(U(:,3))),'k-',x,unwrap(angle(Ub(:,3))),':k');
xlabel('x');
subplot(2,2,4)
plot(x,unwrap(angle(UR(:,4))),'k--',x,unwrap(angle(U(:,4))),'k-',x,unwrap(angle(Ub(:,4))),':k');
xlabel('x');
pause;
clf;
subplot(2,1,1)
plot(x,abs(U-Ub),'k-')
subplot(2,1,2)
plot(x,abs(U-UR),'k-')
pause;





% 
% 
% 
