% program 6_6.m
% modification of program bornrytov2.m
% modification of bornrytov1.m
% this program computes the error between the exact and Rytov  approximations 
% of the field scattered  by a penetrable cylinder at fixed  wavenumber as a function
% of index of refraction and four different distances radii of the cylinder
% 
%
% based on the theory developed in chapter 6 of book
% generates figs. 6.11 and 6.12 in chapter 6 of book.
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of cylinder
radius=lambda0*[1,2,3,4];
Nrad=length(radius);
% max l=k00*a0;
L=round(k00*radius(4))+20;
Ll=[0:L-1];
% set  n of cylinder
nc=[1.0:.01:1.1];
nrel=100*(nc-1);
Nc=length(nc);
k0=k00; 
% distance to measurement line
% selected by user
%z0=radius(4)+200*lambda0;
z0=radius(4)+lambda0
% x=r sin phi=z tan phi, 
x0=z0*tan(pi/4);
Nx=1000;
delx=2*x0/Nx;
x=[-x0:delx:x0];
Nx=length(x);
% phi=atan(x/z0);
phi=atan(x/z0).';
% r=sqrt(x^2+z0^2)
kr=k0*sqrt(x.^2+z0^2).';
% 
% set up fast computation using array processing
%%%
% compute for l=0 to L-1
%
H1=2*cos(phi*Ll);
H1(:,1)=1;
H=besselh(Ll,kr).*H1;
%
% zero angle of incidence of plane wave
alpha0=0;
% loop over cylinder radii
for nrad=1:Nrad;
    a0=radius(nrad);% 
% 
% loop over cylinder indicies
% 
for ncount=1:Nc;
    ncyl=nc(ncount);
    k=k0*ncyl;
% loop over bessel indicies l
    % highest index =L-1
         for l=1:L;
             ll=l-1;           
    % compute transmission coefficient from chap 8
    denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
     numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
     mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
     end;
R=numer./(denom+eps);
% Born reflection coefficient
RB=-i*pi/2*k0^2*(1-ncyl^2)*mu0;
%
% compute scattered field over line located at z0
%
%  perform computation using array processing
%
% use results from chap 8 on born scat from cylinder
%
% exact
% 
bl=i.^(Ll).*R;
% Born
blB=i.^(Ll).*RB;
%
% compute scattered field over line at l0
%
%
% compute exact, born and Rytov total fields over measurement line
%
U(:,ncount)=H*bl.';
Ub(:,ncount)=H*blB.';
U=exp(i*k0*z0)+U;
 phirytov=z0-i/k0*exp(-i*k0*z0)*Ub;
Ub=exp(i*k0*z0)+Ub;
 UR=exp(i*k0*phirytov);
 Eb(ncount,nrad)=100*(norm(U(:,ncount)-Ub(:,ncount)))./norm(U(:,ncount)-exp(i*k0*z0)+eps);
 Er(ncount,nrad)=100*(norm(U(:,ncount)-UR(:,ncount)))./norm(U(:,ncount)-exp(i*k0*z0)+eps);
% Eb(ncount,nrad)=100*(norm(U(:,ncount)-Ub(:,ncount)))./norm(U(:,ncount)+eps);
% Er(ncount,nrad)=100*(norm(U(:,ncount)-UR(:,ncount)))./norm(U(:,ncount)+eps);
end;
end;
% clf;
% plot(nrel,Er,'k-',nrel,Eb,'k-');
% grid on;
% pause;
subplot(2,1,1)
plot(nrel,Er(:,1),'k-',nrel,Er(:,2),'k-',nrel,Er(:,3),'k-',nrel,Er(:,4),'k-');
xlabel('relative index in percent');
ylabel('percent error of scattered field')
grid on;
subplot(2,1,2)
plot(nrel,Eb(:,1),'k-',nrel,Eb(:,2),'k-',nrel,Eb(:,3),'k-',nrel,Eb(:,4),'k-');
xlabel('relative index in percent');
ylabel('percent error of scattered field')
grid on;
% pause;
% subplot(2,1,1)
%  plot(nrel*radius(1),Er(:,1),'k-',nrel*radius(2),Er(:,2),'k.-',nrel*radius(3),Er(:,3),'k--',nrel*radius(4),Er(:,4),'k:');
%  subplot(2,1,2)
%  plot(nrel*radius(1),Eb(:,1),'k-',nrel*radius(2),Eb(:,2),'k.-',nrel*radius(3),Eb(:,3),'k--',nrel*radius(4),Eb(:,4),'k:'); 
% xlabel('product of rer(lative index in percent with radii');
% ylabel('error in percent');
% grid on

