% program chap7_2.m
% modification of old chap8_2.m by ajd april 2011
% computes scattered field and total fields from a conducting cylinder
% used for plots in chapter 7 of book
% written by A.J. Devaney Feb 2008
% used to generate fig.7.2 in chapter 7
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
lambda=1;
k=2*pi/lambda;
% assume incident plane wave propagating in +z direction
% delx = sample distance = lambda/4; 2N+1=total number of sample points on
% x,z plane within cloaking structure
N=1000;
%
% Now compute incident plane wave using Bessel expansion
%
M=N;
deltheta=2*pi/M;
thet=deltheta*[0:M-1].';
% generate an MxM0 array with columns=thet and rows indicies for bessel
% functions
delr=lambda/30;
kr=k*delr*[0:M-1];
ka=max(kr);
% select radius of perfectly conducting scatterer
a0=5;
ind=find(kr==k*a0);
ka_0=kr(ind);
M0=round(ka);
theta=repmat(thet,1,M0);
% create index array
nu=(1:M0);
% besselj(nu,x)=x column and nu row
besspart=besselj(nu.',kr);
% create M0xM array with each row indexed by kr vector and columns indexing indicies
besspart=besspart.';
% create MxM0 array with each row=index vector
nnn=repmat(nu,M,1);
% arrg=MxM0 array=nu theta_n: nu indicies rows and theta columns
arrg=nnn.*theta;
% MxM0 array=i^nu cos(nu theta)
thetpart=exp(i*pi/2*nnn).*cos(arrg);
% out=sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)=MxM array with cols=theta
% and rows=kr
out=thetpart*besspart;
% psi^i=J_0(kr)+2sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)
out=2*out+repmat(besselj(0,kr),M,1);
%
r=kr/k;
[Thet,R]=ndgrid(thet.',r);
[x,y]=pol2cart(Thet,R);
% mesh(x,y,real(out));
% title('Mesh plot of real part of incident plane wave');
% pause;
%%%%%%%%%%%%%%%%%%
% now compute field scattered by a conducting cylinder of radius a
%
% limit output r range to be outside scatterer volume
krr=k*delr*[ind:M-1];
M2=M-ind;
% besselh(nu,x)=x column and nu row=M2xM matrix
besspart2=besselh(nu.',krr);
% create scat coef row vector of length M 
coefsc1=-besselj(nu,ka_0)./besselh(nu,ka_0);
% expand into a M2xM matrix
coefsc=repmat(coefsc1,M2,1);
% create M0xM2 array with each row indexed by kr vector and columns indexing indicies
besspart2n=coefsc.'.*besspart2.';
% keep MxM0 arrays with theta dependence
% MxM0 array=i^nu cos(nu theta): thetpart=exp(i*pi/2*nnn).*cos(arrg);
% outp=-sum_{nu=1}^M0 J_nu(ka_0)/H_nu(ka_0) i^nu cos(nu theta)H_nu(kr)=MxM2 array with cols=theta
% and rows=kr
% create MxM2 array with cols indexed by theta and rows by kr from kr=ka_0 to
% max kr
besspart2n=thetpart*besspart2n;
% create zero index array
cn0=-besselj(0,ka_0)./besselh(0,ka_0);
zeroindex=cn0.*repmat(besselh(0,krr),M,1);
scat=zeros(M);
% create scattered field array
scat(:,ind:M-1)=zeroindex+2*besspart2n;
% psi^i=J_0(kr)+2sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)
%
% save scattered field expansion coefficients for later use
%%%%%%%%%%%%%%
save scatcoef M0 cn0 coefsc1;
%
% now create total field outside scatterer
%
incid=zeros(M);
incid(:,ind:M-1)=out(:,ind:M-1);
total=incid+scat;
subplot(1,2,2)
h1=mesh(x,y,abs(scat));
ht1=title('Mesh plot of absolute value of scattered field');
set(ht1,'fontsize',15);
view(2);
grid on 
axis equal;
axis([-40 40 -40 40]);
ha1=gca;
colorbar
colormap(gray)
subplot(1,2,1)
h2=mesh(x,y,abs(total));
ht2=title('Mesh plot of absolute valueof total field');
view(2);
axis equal;
axis([-40 40 -40 40]);
grid on
colorbar
colormap(gray)
set(ht2,'fontsize',15);
ha2=gca;
set(ha1,'fontsize',13);
set(ha2,'fontsize',13);



