% program chap7_3.m
% modification of dn_rp1 by ajd april 2011
% computes radiation pattern  of scattered field from a Dirichlet and Neumann cylinder
% 
% program generates figs.7.3 and 7.4 in chapter 7 of book
%  written by A.J. Devaney Feb 2008
% program requires user interface to label plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
lambda=1;
k=2*pi/lambda;
delr=lambda/30;
% assume incident plane wave propagating in +z direction
% delx = sample distance = lambda/4; 2N+1=total number of sample points on
% x,z plane within cloaking structure
N=1000;
a=N*delr;
ka=k*a;
M0=round(ka);
%
% Now compute incident plane wave using Bessel expansion
%
M=N;
deltheta=2*pi/M;
thet=deltheta*[1:M].';
% generate an MxM0 array with columns=thet and rows indicies for angles
%  
theta=repmat(thet,1,M0);
a0=[1,2,3,4];
% create index array
nu=(1:M0);
% create MxM0 array with each row=index vector
nnn=repmat(nu,M,1);
% arrg=MxM0 array=nu theta_n: nu indicies rows and theta columns
arrg=nnn.*theta;
% MxM0 array=cos(nu theta)
thetpart=cos(arrg);
%%%%%%%%%%%%%%%%%%
% now compute radiation pattern of field scattered by a conducting cylinder
% of radius a_0
% multiplying factor
fact=sqrt(2/(pi*k))*exp(-i*pi/4);
% following used by PO approximation
% deltathetap=pi/N;
% thetp=pi/2+deltathetap*(0:N).';
deltathetap=pi/N;
thetp=pi/2+deltathetap*(0:N).';
%thetp=theta(M/4:3*M/4).';
Mp=length(thetp);
% thetap is M0xMp
thetap=repmat(thetp.',M0,1) ;
for nn=1:4;
% select radius of  scatterer
a_0=a0(nn);
ka_0=k*a_0;
% create scat coef row vector of length M 
nnu=nu-1;
npu=nu+1;
numern=1/2*(besselj(nnu.',ka_0)-besselj(npu.',ka_0)).';
numern0=besselj(1,ka_0);
denomn=1/2*(besselh(nnu.',ka_0)-besselh(npu.',ka_0)).';
denomn0=besselh(1,ka_0);
numer=besselj(nu,ka_0);
denom=besselh(nu,ka_0);
numer0=besselj(0,ka_0);
denom0=besselh(0,ka_0);
coefsc0=-numer0./(denom0+eps);
coefsc1=-numer./(denom+eps);
fd(:,nn)=fact*(coefsc0+2*thetpart*coefsc1.');
% now do Neumann Case
coefsc0=-numern0./(denomn0);
coefsc1=-numern./(denomn);
fn(:,nn)=fact*(coefsc0+2*thetpart*coefsc1.');
end;
s1='a_0= ';
s2='  \lambda ';
fds=fd; 
 fns=fn; 
subplot(2,4,1)
polar(thet,abs(fds(:,1)),'-k');
subplot(2,4,2)
polar(thet,abs(fns(:,1)),'-k');
hg1=gtext([s1,num2str(a0(1)),s2])
set(hg1,'fontsize',13);
subplot(2,4,3)
polar(thet,abs(fds(:,2)),'-k');
subplot(2,4,4)
polar(thet,abs(fns(:,2)),'-k');
hg1=gtext([s1,num2str(a0(2)),s2])
set(hg1,'fontsize',13);
subplot(2,4,5)
polar(thet,abs(fds(:,3)),'-k');
subplot(2,4,6)
polar(thet,abs(fns(:,3)),'-k');
hg1=gtext([s1,num2str(a0(3)),s2])
set(hg1,'fontsize',13);
subplot(2,4,7)
polar(thet,abs(fds(:,4)),'-k');
subplot(2,4,8)
polar(thet,abs(fns(:,4)),'-k');
hg1=gtext([s1,num2str(a0(4)),s2]);
set(hg1,'fontsize',13);
pause
% clf;
% subplot(1,2,1)
% polar(thet,abs(fds(:,1)),'-k');
% subplot(1,2,2)
% polar(thet,abs(fns(:,1)),'-k');
% gtext([s1,num2str(a0(1)),s2])
% pause;
% clf;
% subplot(1,2,1)
% polar(thet,abs(fds(:,2)),'-k');
% subplot(1,2,2)
% polar(thet,abs(fns(:,2)),'-k');
% gtext([s1,num2str(a0(2)),s2])
% pause;
% subplot(1,2,1)
% polar(thet,abs(fds(:,1)),'-k');
% subplot(1,2,2)
% polar(thet,abs(fns(:,1)),'-k');
% gtext([s1,num2str(a0(1)),s2])
% pause;
clf;
subplot(2,2,1)
h1=plot(thet,fftshift(abs(fds(:,1))),'-k',thet,fftshift(abs(fns(:,1))),':k');
hg1=gtext([s1,num2str(a0(1)),s2]);
set(hg1,'fontsize',13);
ha1=gca;
hline=get(ha1,'children');
set(hline(1),'linewidth',1.5,'linestyle','-');
set(hline(2),'linewidth',1.5,'linestyle',':');
subplot(2,2,2)
plot(thet,fftshift(abs(fds(:,2))),'-k',thet,fftshift(abs(fns(:,2))),':k');
hg1=gtext([s1,num2str(a0(2)),s2]);
set(hg1,'fontsize',13);
ha1=gca;
hline=get(ha1,'children');
set(hline(1),'linewidth',1.5,'linestyle','-');
set(hline(2),'linewidth',1.5,'linestyle',':');
subplot(2,2,3)
plot(thet,fftshift(abs(fds(:,3))),'-k',thet,fftshift(abs(fns(:,3))),':k');
hg1=gtext([s1,num2str(a0(3)),s2]);
set(hg1,'fontsize',13);
ha1=gca;
hline=get(ha1,'children');
set(hline(1),'linewidth',1.5,'linestyle','-');
set(hline(2),'linewidth',1.5,'linestyle',':');
subplot(2,2,4)
plot(thet,fftshift(abs(fds(:,4))),'-k',thet,fftshift(abs(fns(:,4))),':k');
hg1=gtext([s1,num2str(a0(4)),s2]);
set(hg1,'fontsize',13);
ha1=gca;
hline=get(ha1,'children');
set(hline(1),'linewidth',1.5,'linestyle','-');
set(hline(2),'linewidth',1.5,'linestyle',':');

% set(hline(3),'linewidth',1.5,'linestyle','-','marker','o');
% set(hline(4),'linewidth',1.5,'linestyle','-','marker','x');
% set(hline(1),'linewidth',1.5,'linestyle','-','marker','*');
% set(hline(2),'linewidth',1.5,'linestyle','-','marker','+');
%set(ha2,'fontsize',13,'xminortick','on')
% set(hline(3),'linewidth',1.5,'linestyle','-');
% set(hline(4),'linewidth',1.5,'linestyle','-');
% set(hline(1),'linewidth',1.5,'linestyle','-');
% set(hline(2),'linewidth',1.5,'linestyle','-');
% pause;
% fes=fe; fes(1:M/20,:)=0; fes(19*M/20:M,:)=0;
%  fpos=fpo; fpos(1:M/20,:)=0; fpos(19*M/20:M,:)=0;
% subplot(2,4,1)
% polar(thet,abs(fes(:,1)),'-k');
% subplot(2,4,2)
% polar(thet,abs(fpos(:,1)),'-k');
% gtext([s1,num2str(a0(1))])
% subplot(2,4,3)
% polar(thet,abs(fes(:,2)),'-k');
% subplot(2,4,4)
% polar(thet,abs(fpos(:,2)),'-k');
% gtext([s1,num2str(a0(2))])
% subplot(2,4,5)
% polar(thet,abs(fes(:,3)),'-k');
% subplot(2,4,6)
% polar(thet,abs(fpos(:,3)),'-k');
% gtext([s1,num2str(a0(3))])
% subplot(2,4,7)
% polar(thet,abs(fes(:,4)),'-k');
% subplot(2,4,8)
% polar(thet,abs(fpos(:,4)),'-k');
% gtext([s1,num2str(a0(4))])
% pause;
% clf;
% fed=fd(1:4:M,:); 
% fpod=fn(1:4:M,:); 
% thetd=180/pi*thet(1:4:M);
% subplot(4,1,1)
% semilogy(thetd,abs(fed(:,1)),'-k',thetd,abs(fpod(:,1)),'-ok');
% gtext([s1,num2str(a0(1))])
% subplot(4,1,2)
% semilogy(thetd,abs(fed(:,2)),'-k',thetd,abs(fpod(:,2)),'-ok');
% gtext([s1,num2str(a0(2))])
% subplot(4,1,3)
% semilogy(thetd,abs(fed(:,3)),'-k',thetd,abs(fpod(:,3)),'-ok');
% gtext([s1,num2str(a0(3))])
% subplot(4,1,4)
% semilogy(thetd,abs(fed(:,4)),'-k',thetd,abs(fpod(:,4)),'-ok');
% gtext([s1,num2str(a0(4))])
% pause;
% fed=fd(M/200:4:190/200*M,:); 
% fpod=fn(M/200:4:190/200*M,:); 
% thetd=180/pi*thet(M/200:4:190/200*M);
% subplot(4,1,1)
% plot(thetd,real(fed(:,1)),'.k',thetd,real(fpod(:,1)),'-ok');
% gtext([s1,num2str(a0(1))])
% subplot(4,1,2)
% plot(thetd,real(fed(:,2)),'.k',thetd,real(fpod(:,2)),'-ok');
% gtext([s1,num2str(a0(2))])
% subplot(4,1,3)
% plot(thetd,real(fed(:,3)),'.k',thetd,real(fpod(:,3)),'-ok');
% gtext([s1,num2str(a0(3))])
% subplot(4,1,4)
% plot(thetd,real(fed(:,4)),'.k',thetd,real(fpod(:,4)),'-ok');
% gtext([s1,num2str(a0(4))])
