% program 7_4.m
% modification of program po_d
% modification of chap8_4.m
% computes scattered field from a conducting cylinder and compares result
% with physical optics approximation
% written by A.J. Devaney Feb 2008 modified finally april 2011
% generates figs7.6 and 7.7 in chapter 7
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
lambda=1;
k=2*pi/lambda;
% assume incident plane wave propagating in +z direction
% delx = sample distance = lambda/4; 2N+1=total number of sample points on
% x,z plane within cloaking structure
N=1000;
%
% Now compute incident plane wave using Bessel expansion
%
M=N;
deltheta=2*pi/M;
thet=deltheta*[1:M].';
% generate an MxM0 array with columns=thet and rows indicies for bessel
% functions
delr=lambda/30;
kr=k*delr*[0:M-1];
ka=max(kr);
% select radius of perfectly conducting scatterer
%ind=400;
a0=5;
ind=find(kr==k*a0);
ka_0=kr(ind);
a0=num2str(a0);
M0=round(ka);
theta=repmat(thet,1,M0);
% create index array
nu=(1:M0);
% besselj(nu,x)=x column and nu row
besspart=besselj(nu.',kr);
% create M0xM array with each row indexed by kr vector and columns indexing indicies
besspart=besspart.';
% create MxM0 array with each row=index vector
nnn=repmat(nu,M,1);
% arrg=MxM0 array=nu theta_n: nu indicies rows and theta columns
arrg=nnn.*theta;
% MxM0 array=i^nu cos(nu theta)
thetpart=exp(i*pi/2*nnn).*cos(arrg);
% out=sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)=MxM array with cols=theta
% and rows=kr
out=thetpart*besspart;
% psi^i=J_0(kr)+2sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)
out=2*out+repmat(besselj(0,kr),M,1);
%
r=kr/k;
[Thet,R]=ndgrid(thet.',r);
[x,y]=pol2cart(Thet,R);
% mesh(x,y,real(out));
% title('Mesh plot of real part of incident plane wave');
% pause;
%%%%%%%%%%%%%%%%%%
% now compute field scattered by a conducting cylinder of radius a
%
% limit output r range to be outside scatterer volume
krr=k*delr*[ind:M-1];
M2=M-ind;
% besselh(nu,x)=x column and nu row=M2xM matrix
besspart2=besselh(nu.',krr);
% create scat coef row vector of length M 
coefsc1=-besselj(nu,ka_0)./besselh(nu,ka_0);
% expand into a M2xM matrix
coefsc=repmat(coefsc1,M2,1);
% create M0xM2 array with each row indexed by kr vector and columns indexing indicies
besspart2n=coefsc.'.*besspart2.';
% keep MxM0 arrays with theta dependence
% MxM0 array=i^nu cos(nu theta): thetpart=exp(i*pi/2*nnn).*cos(arrg);
% outp=-sum_{nu=1}^M0 J_nu(ka_0)/H_nu(ka_0) i^nu cos(nu theta)H_nu(kr)=MxM2 array with cols=theta
% and rows=kr
% create MxM2 array with cols indexed by theta and rows by kr from kr=ka_0 to
% max kr
besspart2n=thetpart*besspart2n;
% create zero index array
cn0=-besselj(0,ka_0)./besselh(0,ka_0);
zeroindex=cn0.*repmat(besselh(0,krr),M,1);
scat=zeros(M);
% create scattered field array
scat(:,ind:M-1)=zeroindex+2*besspart2n;
% psi^i=J_0(kr)+2sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)
%
% save scattered field expansion coefficients for later use
%%%%%%%%%%%%%%
% mesh(x,y,real(scat));
% title('Mesh plot of real part of scattered field outside of scatterer region');
% pause;
%
% now create total field outside scatterer
%
incid=zeros(M);
incid(:,ind:M-1)=out(:,ind:M-1);
total=incid+scat;
% mesh(x,y,real(total));
% title('Mesh plot of real part of total field outside of scatterer region');
% pause;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% now compute physical optics approximation to scattered field
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% use incident field over lit portion of cylinder
% propagate from boundary of scatterer 
% 
% deltathetap=pi/N;
% thetp=pi/2+deltathetap*(0:N).';
deltathetap=pi/N;
thetp=pi/2+deltathetap*(0:N).';
%thetp=theta(M/4:3*M/4).';
Mp=length(thetp);
% thetap is M0xMp
thetap=repmat(thetp.',M0,1) ;
% boundary value of normal derivative of incident wave over lit region of cylinder
v=cos(thetp).*exp(i*ka_0*cos(thetp));
% v is  column vector of length Mp
% nnnp and arrgp are M0xMp
nnnp=repmat(nu.',1,Mp);
arrgp=nnnp.*thetap;
Ma=deltathetap*exp(-i*arrgp);
coef=Ma*v;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
coefa=coef;
% compute coefficients for physical optics approximation
coefp=ka_0*besselj(nu.',ka_0).*coefa;
% compute index zero coefficient
C0=deltathetap*sum(v); 
temp0=C0;
C0p=ka_0/2*besselj(0,ka_0).*temp0;
%%%%%%%%%%%  
% generate scattered wave using physical optics approximation
%  
%%%%%%%%%%%%%%%%%%
% create MxM0 array with each row=index vector
coefrep=repmat(coefp.',M,1);
thetpartp=coefrep.*cos(arrg);
% out=sum_{nu=1}^M0 i^nu cos(nu theta)J_nu(kr)=MxM array with cols=theta
% and rows=kr
outp=zeros(M,M);
outp(:,ind:M-1)= thetpartp*besspart2.'+C0p*repmat(besselh(0,krr),M,1);
totalp=incid+outp;
%%%%%%
subplot(2,2,1)
mesh(x,y,abs(totalp));
ht1=title(['Magnitude of P.O. approximation of total field with a_0= ',a0, ' \lambda']);
set(ht1,'fontsize',13)
view(2);
axis equal;
axis([-40 40 -40 40]);
colormap(gray)
colorbar
subplot(2,2,2)
mesh(x,y,abs(total));
ht1=title(['Magnitude of exact total field with a_0= ',a0, ' \lambda']);
set(ht1,'fontsize',13)
view(2);
axis equal;
axis([-40 40 -40 40]);
colormap(gray)
colorbar
%%
subplot(2,2,3)
mesh(x,y,real(outp));
ht1=title(['Real part of P.O. approximation of scattered field with a_0= ',a0, ' \lambda']);
set(ht1,'fontsize',13)
view(2);
axis equal;
axis([-40 40 -40 40]);
colormap(gray)
colorbar
subplot(2,2,4)
mesh(x,y,real(scat));
ht1=title(['Real part of exact scattered Field with a_0= ',a0, ' \lambda']);
set(ht1,'fontsize',13)
view(2);
axis equal;
axis([-40 40 -40 40]);
colormap(gray)
colorbar
pause; 
tscat=scat(1:4:N,ind+30);
toutp= outp(1:4:N,ind+30);
tthet=180/pi*thet(1:4:N);
%  tscat=scat(1:4:N,N-1);
%  outp= outp(1:4:N,N-1);
subplot(2,2,1)
plot(tthet,abs(tscat),'-k',tthet,abs(toutp),'-.k');
h1=title(['Magnitudes of U^{(s)} and U_{P.O.}^{(s)} one wavelength outside cylinder with a_0= ',a0, ' \lambda']);
set(h1,'fontsize',13);
%legend('Exact','Physical Optics Approximation')
subplot(2,2,2)
plot(tthet,unwrap(angle(tscat)),'-k',tthet,unwrap(angle(toutp)),'-.k');
h1=title(['Phases of U^{(s)} and U_{P.O.}^{(s)} one wavelength outside cylinder with a_0= ',a0, ' \lambda']);
set(h1,'fontsize',13);
subplot(2,2,3)
plot(tthet,abs(tscat./(toutp+eps)),'-k');
h1=title('Ratio of the magnitudes of U^{(s)} and U_{P.O.}^{(s)} one wavelength outside cylinder');
set(h1,'fontsize',13);
subplot(2,2,4)
plot(tthet,unwrap(angle(tscat./(toutp+eps))),'-k');
h1=title('Phase difference between U^{(s)} and U_{P.O.}^{(s)} one wavelength outside cylinder');
set(h1,'fontsize',13);
 
