% program 7_5.m
% modification of program po_d_rp by ajd april 2011
% computes radiation pattern  of scattered field from a conducting cylinder
% compares with PO approximation
% used to generate fig.7.8 in chapter 8 of book
%  written by A.J. Devaney Feb 2008
% program requires user interface to label plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
lambda=1;
k=2*pi/lambda;
delr=lambda/30;
% assume incident plane wave propagating in +z direction
% delx = sample distance = lambda/4; 2N+1=total number of sample points on
% x,z plane within cloaking structure
N=1000;
a=N*delr;
ka=k*a;
M0=round(ka);
%
% Now compute incident plane wave using Bessel expansion
%
M=N;
deltheta=2*pi/M;
thet=deltheta*[1:M].';
% generate an MxM0 array with columns=thet and rows indicies for angles
%  
theta=repmat(thet,1,M0);
deln=100;
% create index array
nu=(1:M0);
% create MxM0 array with each row=index vector
nnn=repmat(nu,M,1);
% arrg=MxM0 array=nu theta_n: nu indicies rows and theta columns
arrg=nnn.*theta;
% MxM0 array=cos(nu theta)
thetpart=cos(arrg);
%%%%%%%%%%%%%%%%%%
% now compute radiation pattern of field scattered by a conducting cylinder
% of radius a_0
% multiplying factor
fact=sqrt(2/(pi*k))*exp(-i*pi/4);
% following used by PO approximation
% deltathetap=pi/N;
% thetp=pi/2+deltathetap*(0:N).';
deltathetap=pi/N;
thetp=pi/2+deltathetap*(0:N).';
%thetp=theta(M/4:3*M/4).';
Mp=length(thetp);
% thetap is M0xMp
thetap=repmat(thetp.',M0,1) ;
a0=[1,2,3,4];
for nn=1:4;
% ind=nn*deln;
% select radius of perfectly conducting scatterer
a_0=a0(nn);
ka_0=k*a_0;
%ind=find(kr==ka_0);
% create scat coef row vector of length M 
nnu=nu-1;
npu=nu+1;
% numer=1/2*(besselj(nnu.',ka_0)-besselj(npu.',ka_0)).';
% numer0=besselj(1,ka_0);
% denom=1/2*(besselh(nnu.',ka_0)-besselh(npu.',ka_0)).';
% denom0=besselh(1,ka_0);
numer=besselj(nu,ka_0);
denom=besselh(nu,ka_0);
numer0=besselj(0,ka_0);
denom0=besselh(0,ka_0);
coefsc0=-numer0./(denom0+eps);
coefsc1=-numer./(denom+eps);
fe(:,nn)=fact*(coefsc0+2*thetpart*coefsc1.');
% now do P.O. approximation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% now compute physical optics approximation to scattered field
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% use incident field over lit portion of cylinder
% propagate from boundary of scatterer 
% 
% % boundary value of incident wave over lit region of cylinder
% v=exp(i*ka_0*cos(thetp));
% boundary value of incident wave over lit region of cylinder
v= cos(thetp).*exp(i*ka_0*cos(thetp));
% v is  column vector of length Mp
% nnnp and arrgp are M0xMp
nnnp=repmat(nu.',1,Mp);
arrgp=nnnp.*thetap;
Ma=deltathetap*exp(-i*arrgp);
coef=Ma*v;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
coefa=coef.*exp(-i*pi/2*nu.');
% compute coefficients for physical optics approximation
% coefp=-i*ka_0/2*(besselj(nnu.',ka_0)-besselj(npu.',ka_0)).*coefa;
coefp= besselj(nu.',ka_0).*coefa;
% compute index zero coefficient
C0=deltathetap*sum(v); 
temp0=C0;
% C0p=i*ka_0/2*besselj(1,ka_0).*temp0;
C0p=besselj(0,ka_0).*temp0;
%%%%%%%%%%%  
% generate scattering amplitude using physical optics approximation
%  
%%%%%%%%%%%%%%%%%%
% create MxM0 array with each row=index vector
fpo(:,nn)=ka_0/2*fact*(C0p+2*thetpart*coefp);
end;
s1='a_0= ';s2='  \lambda ';
fes=fe; 
 fpos=fpo; 
subplot(2,4,1)
polar(thet,abs(fes(:,1)),'-k');
subplot(2,4,2)
polar(thet,abs(fpos(:,1)),'-k');
hg1=gtext([s1,num2str(a0(1)),s2]);
set(hg1,'fontsize',13);
subplot(2,4,3)
polar(thet,abs(fes(:,2)),'-k');
subplot(2,4,4)
polar(thet,abs(fpos(:,2)),'-k');
hg1=gtext([s1,num2str(a0(2)),s2]);
set(hg1,'fontsize',13);
subplot(2,4,5)
polar(thet,abs(fes(:,3)),'-k');
subplot(2,4,6)
polar(thet,abs(fpos(:,3)),'-k');
hg1=gtext([s1,num2str(a0(3)),s2]);
set(hg1,'fontsize',13);
subplot(2,4,7)
polar(thet,abs(fes(:,4)),'-k');
subplot(2,4,8)
polar(thet,abs(fpos(:,4)),'-k');
hg1=gtext([s1,num2str(a0(4)),s2]);
set(hg1,'fontsize',13);
% pause
% clf;
% subplot(1,2,1)
% polar(thet,abs(fes(:,1)),'-k');
% subplot(1,2,2)
% polar(thet,abs(fpos(:,1)),'-k');
% gtext([s1,num2str(a0(1))])
% pause;
% fes=fe; fes(1:M/20,:)=0; fes(19*M/20:M,:)=0;
%  fpos=fpo; fpos(1:M/20,:)=0; fpos(19*M/20:M,:)=0;
% subplot(2,4,1)
% polar(thet,abs(fes(:,1)),'-k');
% subplot(2,4,2)
% polar(thet,abs(fpos(:,1)),'-k');
% gtext([s1,num2str(a0(1))])
% subplot(2,4,3)
% polar(thet,abs(fes(:,2)),'-k');
% subplot(2,4,4)
% polar(thet,abs(fpos(:,2)),'-k');
% gtext([s1,num2str(a0(2))])
% subplot(2,4,5)
% polar(thet,abs(fes(:,3)),'-k');
% subplot(2,4,6)
% polar(thet,abs(fpos(:,3)),'-k');
% gtext([s1,num2str(a0(3))])
% subplot(2,4,7)
% polar(thet,abs(fes(:,4)),'-k');
% subplot(2,4,8)
% polar(thet,abs(fpos(:,4)),'-k');
% gtext([s1,num2str(a0(4))])
% pause;
% clf;
% fed=fe(1:4:M,:); 
% fpod=fpo(1:4:M,:); 
% thetd=180/pi*thet(1:4:M);
% subplot(4,1,1)
% semilogy(thetd,abs(fed(:,1)),'-k',thetd,abs(fpod(:,1)),'-ok');
% gtext([s1,num2str(a0(1))])
% subplot(4,1,2)
% semilogy(thetd,abs(fed(:,2)),'-k',thetd,abs(fpod(:,2)),'-ok');
% gtext([s1,num2str(a0(2))])
% subplot(4,1,3)
% semilogy(thetd,abs(fed(:,3)),'-k',thetd,abs(fpod(:,3)),'-ok');
% gtext([s1,num2str(a0(3))])
% subplot(4,1,4)
% semilogy(thetd,abs(fed(:,4)),'-k',thetd,abs(fpod(:,4)),'-ok');
% gtext([s1,num2str(a0(4))])
% pause;
% fed=fe(M/200:4:190/200*M,:); 
% fpod=fpo(M/200:4:190/200*M,:); 
% thetd=180/pi*thet(M/200:4:190/200*M);
% subplot(4,1,1)
% plot(thetd,real(fed(:,1)),'.k',thetd,real(fpod(:,1)),'-ok');
% gtext([s1,num2str(a0(1))])
% subplot(4,1,2)
% plot(thetd,real(fed(:,2)),'.k',thetd,real(fpod(:,2)),'-ok');
% gtext([s1,num2str(a0(2))])
% subplot(4,1,3)
% plot(thetd,real(fed(:,3)),'.k',thetd,real(fpod(:,3)),'-ok');
% gtext([s1,num2str(a0(3))])
% subplot(4,1,4)
% plot(thetd,real(fed(:,4)),'.k',thetd,real(fpod(:,4)),'-ok');
% gtext([s1,num2str(a0(4))])
