% program chap7_6.m
% computes radiation pattern  of scattered field from a Dirichlet and Neumann cylinder
% using multipole expansion and bkpropagates using angular spectrum via matrix multiplication
% generates estimates of the bounary of the cylinder using back propagation
% and sum over vies
% used for figs.7.9-7.11 in chapter 7 of book
%  written by A.J. Devaney Feb 2010
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
lambda=1;
k=2*pi/lambda;
% assume incident plane wave propagating in +z direction
% 
N=1024;
a0=5*lambda;
ka=k*a0+5;
M0=round(ka);
%
% angle of incident plane wave to cylinder
%
theta0=0;
%
% Now compute incident plane wave using Bessel expansion
%
M=N+1;
% chose angles for conversion to Krho
% select delK
kmax=.99*k;
delK=2*kmax/N;
Krho=delK*[-N/2:N/2];
thet=asin(Krho/k).';
% generate an MxM0 array with columns=thet and rows indicies for angles
%  
gamma=k*cos(thet);
%
% generate an MxM0 array with columns=thet and rows indicies for angles
%  
theta=repmat(thet,1,M0);
% create index array
nu=(1:M0);
% create MxM0 array with each row=index vector
nnn=repmat(nu,M,1);
% arrg=MxM0 array=nu theta_n: nu indicies rows and theta columns
arrg=nnn.*(theta-theta0);
% MxM0 array=cos(nu theta)
thetpart=cos(arrg);
%%%%%%%%%%%%%%%%%%
% now compute radiation pattern of field scattered by a conducting cylinder
% of radius a_0
% multiplying factor
fact=sqrt(2/(pi*k))*exp(-i*pi/4);
% select radius of  scatterer
a_0=a0;
ka_0=k*a_0;
% create scat coef row vector of length M 
% create scat coef row vector of length M 
nnu=nu-1;
npu=nu+1;
numern=1/2*(besselj(nnu.',ka_0)-besselj(npu.',ka_0)).';
numern0=besselj(1,ka_0);
denomn=1/2*(besselh(nnu.',ka_0)-besselh(npu.',ka_0)).';
denomn0=besselh(1,ka_0);
numer=besselj(nu,ka_0);
denom=besselh(nu,ka_0);
numer0=besselj(0,ka_0);
denom0=besselh(0,ka_0);
coefsc0=-numer0./(denom0+eps);
coefsc1=-numer./(denom+eps);
fd=fact*(coefsc0+2*thetpart*coefsc1.');
% now do Neumann Case
coefsc0=-numern0./(denomn0);
coefsc1=-numern./(denomn);
fn=fact*(coefsc0+2*thetpart*coefsc1.');
s1='a_0= ';
s2='  \lambda ';
%
clf;
%plot(thet,(abs(fd)),'-k',thet,(abs(fn)),':k');
%gtext([s1,num2str(a0),s2])
%
% now bkprop using angular spectrum implemented via matrix multiplication
%
Nz=N;
delx=lambda/16;
x=delx*[-N/2:N/2];
delz=delx;
zz0=-delz*Nz/2;
z=zz0+delz*(0:Nz);
Z=repmat(z,N+1,1);
% now bkprop using matrix multiplication rather than fft
% arrays are not shifted
%
Gamma=repmat(gamma,1,Nz+1);
% array is (N+1)X(Nz+1)
Adp=sqrt(k/(2*pi))*exp(i*pi/4)*repmat(fd,1,Nz+1).*exp(i*Gamma.*Z)./Gamma;
% array is (Nx+1)X(N+1)
arg=x.'*Krho;
Xe=exp(i*arg);
out=delK*Xe*Adp;
UT=exp(i*k*Z)+out;
subplot(1,2,1)
imagesc(z,x,abs(UT));
axis equal
grid on
colorbar
colormap(gray)
subplot(1,2,2)
imagesc(z,x,abs(out));
axis equal
grid on
colorbar
colormap(gray)
pause;
%%%%%%%%%%%%%%%
% now do angular
%%%%%%%%%%%%
% Now compute incident plane wave using Bessel expansion
%
M=N+1;
% chose angles for conversion to Krho
% select delK
kmax=k;
deltheta=pi/N;
thet=deltheta*(-N/2:N/2).';
% generate an MxM0 array with columns=thet and rows indicies for angles
%  
gamma=k*cos(thet);
%
% generate an MxM0 array with columns=thet and rows indicies for angles
%  
theta=repmat(thet,1,M0);
% create index array
nu=(1:M0);
% create MxM0 array with each row=index vector
nnn=repmat(nu,M,1);
% arrg=MxM0 array=nu theta_n: nu indicies rows and theta columns
arrg=nnn.*(theta-theta0);
% MxM0 array=cos(nu theta)
thetpart=cos(arrg);
%%%%%%%%%%%%%%%%%%
% now compute radiation pattern of field scattered by a conducting cylinder
% of radius a_0
% multiplying factor
fact=sqrt(2/(pi*k))*exp(-i*pi/4);
% select radius of  scatterer
a_0=a0;
ka_0=k*a_0;
% create scat coef row vector of length M 
% create scat coef row vector of length M 
nnu=nu-1;
npu=nu+1;
numern=1/2*(besselj(nnu.',ka_0)-besselj(npu.',ka_0)).';
numern0=besselj(1,ka_0);
denomn=1/2*(besselh(nnu.',ka_0)-besselh(npu.',ka_0)).';
denomn0=besselh(1,ka_0);
numer=besselj(nu,ka_0);
denom=besselh(nu,ka_0);
numer0=besselj(0,ka_0);
denom0=besselh(0,ka_0);
coefsc0=-numer0./(denom0+eps);
coefsc1=-numer./(denom+eps);
fd=fact*(coefsc0+2*thetpart*coefsc1.');
% now do Neumann Case
coefsc0=-numern0./(denomn0);
coefsc1=-numern./(denomn);
fn=fact*(coefsc0+2*thetpart*coefsc1.');
s1='a_0= ';
s2='  \lambda ';
%
%
% now bkprop using angular form of AS
%
Nz=N;
delx=lambda/16;
x=delx*[-N/2:N/2];
delz=delx;
zz0=-delz*Nz/2;
z=zz0+delz*(0:Nz);
Z=repmat(z,N+1,1);
X=repmat(x.',1,M);
% now bkprop using matrix multiplication 
% 
%
Gamma=repmat(gamma,1,Nz+1);
% array is (N+1)X(Nz+1)
Ad=sqrt(k/(2*pi))*exp(i*pi/4)*repmat(fd,1,Nz+1).*exp(i*Gamma.*Z);
Krh=k*sin(thet);
arg=x.'*Krh.';
Xe=exp(i*arg);
outp=deltheta*Xe*Ad;
UTp=exp(i*k*Z)+outp;
subplot(2,1,1)
imagesc(z,x,abs(UTp));
axis equal
grid on
colorbar
subplot(2,1,2)
imagesc(z,x,abs(UT));
axis equal
grid on
colorbar
% generate image superimposing a number of views
Np=100;
delphi=2*pi/Np;
G=zeros(M,M);
H=zeros(M,M);
f=abs(UTp);
g=real(exp(-i*k*Z).*outp);
for np=1:Np;
    phi=(np-1)*delphi; 
Zp=Z*cos(phi)+X*sin(phi);
Xp=-Z*sin(phi)+X*cos(phi);
Fp=interp2(Z,X,f,Zp,Xp);
Gp=interp2(Z,X,g,Zp,Xp);
G=Fp+G;
H=Gp+H;
end;
subplot(1,2,1)
imagesc(z,x,G);
axis equal
grid on
colorbar
colormap(gray)
subplot(1,2,2)
imagesc(z,x,H);
axis equal
grid on
colorbar
colormap(gray)
pause;
Gplt=G(:,N/2)-max(G(:,N/2));
Hplt=H(:,N/2)-max(H(:,N/2));
clf
plot(x,Gplt,'k:',x,Hplt,'k-');
grid on







