  % program chap8_1.m
% computes radiation pattern  of scattered field from a penetrable cylinder
% using multipole expansion and generates inversion using 2D FBP algorithm
% used for plots in chapter 8 of book
%  written by A.J. Devaney Nov 2010
%  used to generate fig.8.1 on chapter 8 in book
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% this program first computes the exact and born approximations of the scattering amplitude of a
% penetrable cylinder at fixed  wavenumber and index of refraction 
% the data is then used to generate an inversion using the 2D fbp algorithm
%  
% based on the theory developed in chapters 8  and 10 of book
%
clear all;
% background wavelength = 1
lambda0=1;
k0=2*pi/lambda0;
% radius of cylinder a0
a0=4*lambda0;
% max l=k00*a0;
L=round(k0*a0)+5;
% set  n of cylinder
nc=[1.005,1.01,1.015,1.02];
% set up angles to compute scattering amplitude
Nalpha=1024;
N=Nalpha;
delalpha=2*pi/Nalpha;
alpha=delalpha*[-Nalpha/2:Nalpha/2];
alpha0=0;
for ncount=1:4;
    ncyl=nc(ncount);
    k=k0*ncyl;
%
% compute scattering amplitudes 
% 
% loop over bessel indicies l
    % highest index = k0*a0
         for l=1:L;
             ll=l-1;           
    % compute transmission coefficient from chap 8
     denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
     numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
     mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
     end;
% compute transmission function
T=2*i/(pi*k0*a0)./(denom+eps);
% T(nf,ni,l) argument=#frequencies, # indicies, index # of bessel functions
R=(numer+eps)./(denom+eps);
%
% compute scattering amplitudes as function of angle
%
for na=1:Nalpha+1;
    fs=0;fsb=0;
    for l=2:L;
        ll=l-1;
        fs=fs+R(l)*cos(ll*(alpha(na)-alpha0));
        fsb=fsb+mu0(l)*cos(ll*(alpha(na)-alpha0));
    end;
    fsc(na)=sqrt(2/(pi*k0))*exp(-i*pi/4)*(R(1)+2*fs);
    fsbo(na)=-sqrt(pi/(2*k0))*exp(i*pi/4)*k0^2*(1-ncyl^2)*(mu0(1)+2*fsb);
end;
%%%%%%%%%%%%%%%
% compute ideal born using closed form
%%%%%%%%%%%%%%%
fsbornp(:,ncount)=-sqrt(pi/(2*k0))*k0^2*a0^2*exp(i*pi/4)*(1-ncyl^2)*(besselj(1,sqrt(2)*k0*a0*sqrt(1-cos(alpha)))+eps)./(sqrt(2)*k0*a0*sqrt(1-cos(alpha))+eps);
fsbornp(N/2+1,ncount)=-sqrt(pi/(2*k0))*k0^2*a0^2*exp(i*pi/4)*(1-ncyl^2)/2;
fscat(:,ncount)=fsc;
fsborn(:,ncount)=fsbo;
end;
%
% plot results
%
subplot(2,2,1)
plot(alpha,real(fscat(:,1)),'k-',alpha,real(fsborn(:,1)),'k:',alpha,real(fsbornp(:,1)),'b-');
xlabel('angle');
subplot(2,2,2)
plot(alpha,real(fscat(:,2)),'k-',alpha,real(fsborn(:,2)),'k:',alpha,real(fsbornp(:,2)),'b-');
xlabel('angle');
subplot(2,2,3)
plot(alpha,real(fscat(:,3)),'k-',alpha,real(fsborn(:,3)),'k:',alpha,real(fsbornp(:,3)),'b-');
xlabel('angle');
subplot(2,2,4)
plot(alpha,real(fscat(:,4)),'k-',alpha,real(fsborn(:,4)),'k:',alpha,real(fsbornp(:,4)),'b-');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,imag(fscat(:,1)),'k-',alpha,imag(fsborn(:,1)),'k:',alpha,imag(fsbornp(:,1)),'b-');
xlabel('angle');
subplot(2,2,2)
plot(alpha,imag(fscat(:,2)),'k-',alpha,imag(fsborn(:,2)),'k:',alpha,imag(fsbornp(:,2)),'b-');
xlabel('angle');
subplot(2,2,3)
plot(alpha,imag(fscat(:,3)),'k-',alpha,imag(fsborn(:,3)),'k:',alpha,imag(fsbornp(:,3)),'b-');
xlabel('angle');
subplot(2,2,4)
plot(alpha,imag(fscat(:,4)),'k-',alpha,imag(fsborn(:,4)),'k:',alpha,imag(fsbornp(:,4)),'b-');
xlabel('angle');
 pause;
subplot(2,2,1)
plot(alpha,abs(fscat(:,1)),'k-',alpha,abs(fsborn(:,1)),'k:',alpha,abs(fsbornp(:,1)),'b-');
xlabel('angle');
subplot(2,2,2)
plot(alpha,abs(fscat(:,2)),'k-',alpha,abs(fsborn(:,2)),'k:',alpha,abs(fsbornp(:,2)),'b-');
xlabel('angle');
subplot(2,2,3)
plot(alpha,abs(fscat(:,3)),'k-',alpha,abs(fsborn(:,3)),'k:',alpha,abs(fsbornp(:,3)),'b-');
xlabel('angle');
subplot(2,2,4)
plot(alpha,abs(fscat(:,4)),'k-',alpha,abs(fsborn(:,4)),'k:',alpha,abs(fsbornp(:,4)),'b-');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,angle(fscat(:,1)),'k-',alpha,angle(fsborn(:,1)),'k:',alpha,angle(fsbornp(:,1)),'b-');
xlabel('angle');
subplot(2,2,2)
plot(alpha,angle(fscat(:,2)),'k-',alpha,angle(fsborn(:,2)),'k:',alpha,angle(fsbornp(:,2)),'b-');
xlabel('angle');
subplot(2,2,3)
plot(alpha,angle(fscat(:,3)),'k-',alpha,angle(fsborn(:,3)),'k:',alpha,angle(fsbornp(:,3)),'b-');
xlabel('angle');
subplot(2,2,4)
plot(alpha,angle(fscat(:,4)),'k-',alpha,angle(fsborn(:,4)),'k:',alpha,angle(fsbornp(:,4)),'b-');
xlabel('angle');
 pause; 
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fscatf=repmat(abs(sin(alpha.')),1,4).*fscat;
fsbornf=repmat(abs(sin(alpha.')),1,4).*fsborn;
fsbornpf=repmat(abs(sin(alpha.')),1,4).*fsbornp;
fscatf1=repmat(hamming(N+1),1,4).*fscatf;
fsbornf1=repmat(hamming(N+1),1,4).*fsbornf;
fsbornpf1=repmat(hamming(N+1),1,4).*fsbornpf;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma=k0*cos(alpha);
delr=2*a0/N;
Kbr=sqrt(1-gamma/k0).';
r=delr*[0:N];
argbr=sqrt(2)*k0*r.'*Kbr.';
%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%
Xgbr=besselj(0,argbr);
%%%%%%%%%%%%%%%%%
outborn=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornf;
outscat=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fscatf;
outbornp=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornpf;
outborn1=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornf1;
outscat1=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fscatf1;
outbornp1=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornpf1;
clf;
subplot(2,1,1)
plot(r,real(outscat),'k-',r,real(outbornp),'k--')
subplot(2,1,2)
plot(r,real(outscat1),'k-',r,real(outbornp1),'k--')
pause;
%
% compute theoretical born inverse
%
% hamming filter
%
% h=hamming(2*N); 
% hf=h(N:2*N);
% delK=2*k0/N;
% K=delK*[0:N];
% Kr=r.'*K;
% Vhat=a0*(k0^2-k^2)*delK*besselj(0,Kr)*besselj(1,K*a0).';
% Vhatf=a0*(k0^2-k^2)*delK*besselj(0,Kr)*(hf.*besselj(1,K*a0).');
% %plot(r,imag(outbornp),'b-',r,real(Vhat),'k-')
% plot(r,Vhat,'k-',r,Vhatf,'k:',r,real(outbornp),'b-')
% pause;
%

