  % program chap8_2.m
% this program computes the scattering amplitude of a pair of concentric 
% penetrable cylinders at fixed  wavenumber and two different
% pairs of indicies of refraction of the cylinders as a function angle alpha
% and generates inversion using 2D FBP algorithm
% used to generate fig.8.2  in chapter 8 of book
%  written by A.J. Devaney Nov 2010 
  clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of inner cylinder a1
a1=2*lambda0;
% radius of outer cylinder a2
a2=4*lambda0;
a0=a2;
% max l=k00*a2;
L=round(k00*a2)+5;
% set  n1 of inner cylinder
nc1=[1.005,1.01,1.015,1.02];
N1=length(nc1);
% set  n2 of outer cylinder shell
nc2=[1.005];
N2=length(nc2);
k0=k00; 
% set up angles to compute scattering amplitude
Nalpha=1024;
N=Nalpha;
delalpha=2*pi/Nalpha;
alpha=delalpha*[-Nalpha/2:Nalpha/2];
alpha0=0;
% 
% loop over cylinder indicies
% 
ncount=0;
for ncount1=1:N1;
    ncyl1=nc1(ncount1);
    k1=k0*ncyl1;
    for ncount2=1:N2;
        ncyl2=nc2(ncount2);
    k2=k0*ncyl2;
    ncount=1+ncount;
% loop over bessel indicies l
    % highest index = k0*a0
         for l=1:L;
             ll=l-1;           
    % compute matrix elements from chap 8
    row1=[-besselj(ll,k1*a1),besselj(ll,k2*a1),0,besselh(ll,k2*a1)];
    row2=[-ncyl1*besselder(ll,k1*a1,0),ncyl2*besselder(ll,k2*a1,0),0,ncyl2*besselder(ll,k2*a1,1)];
    row3=[0,besselj(ll,k2*a2),-besselh(ll,k0*a2),besselh(ll,k2*a2)];
    row4=[0,ncyl2*besselder(ll,k2*a2,0),-besselder(ll,k0*a2,1),ncyl2*besselder(ll,k2*a2,1)];
    H=[row1;row2;row3;row4];
    amp3=besselj(ll,k0*a2);
    amp4=besselder(ll,k0*a2,0);
    A0=[0;0;amp3;amp4];
    A(:,l)=inv(H)*A0; 
    % now do born
    mu1(l)= a1^2/2.*((besselj(ll,k0*a1)).^2-besselj(ll-1,k0*a1).*besselj(ll+1,k0*a1));
     mu2(l)= a2^2/2.*((besselj(ll,k0*a2)).^2-besselj(ll-1,k0*a2).*besselj(ll+1,k0*a2));
          end;
         %
% compute scattering amplitudes as function of angle
%
for na=1:Nalpha+1;
    fs=0;fsb1=0;fsb2=0;
    for l=2:L; 
        ll=l-1;
        fs=fs+A(3,l)*cos(ll*(alpha(na)-alpha0));
      fsb1=fsb1+mu1(l)*cos(ll*(alpha(na)-alpha0));
      fsb2=fsb2+mu2(l)*cos(ll*(alpha(na)-alpha0));
    end;
    fscat(na,ncount)=sqrt(2/(pi*k0))*exp(-i*pi/4)*(A(3,1)+2*fs);
   fsborn(na,ncount)=-sqrt(pi/(2*k0))*exp(i*pi/4)*(k0^2*(ncyl2^2-ncyl1^2)*(mu1(1)+2*fsb1)+k0^2*(1-ncyl2^2)*(mu2(1)+2*fsb2));
 end;
%norm=max(abs(fscat(:,ncount)));
fscatn(:,ncount)=abs(fscat(:,ncount));
% normb=max(abs(fsborn(:,ncount)));
fsbornn(:,ncount)=abs(fsborn(:,ncount));
arge(:,ncount)=(angle(fscat(:,ncount)));
argb(:,ncount)=(angle(fsborn(:,ncount)));  
end;
end;
subplot(2,2,1)
plot(alpha,real(fscat(:,1)),'k-',alpha,real(fsborn(:,1)),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,real(fscat(:,2)),'k-',alpha,real(fsborn(:,2)),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,real(fscat(:,3)),'k-',alpha,real(fsborn(:,3)),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,real(fscat(:,4)),'k-',alpha,real(fsborn(:,4)),'k:');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,imag(fscat(:,1)),'k-',alpha,imag(fsborn(:,1)),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,imag(fscat(:,2)),'k-',alpha,imag(fsborn(:,2)),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,imag(fscat(:,3)),'k-',alpha,imag(fsborn(:,3)),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,imag(fscat(:,4)),'k-',alpha,imag(fsborn(:,4)),'k:');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,fscatn(:,1),'k-',alpha,fsbornn(:,1),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,fscatn(:,2),'k-',alpha,fsbornn(:,2),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,fscatn(:,3),'k-',alpha,fsbornn(:,3),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,fscatn(:,4),'k-',alpha,fsbornn(:,4),'k:');
xlabel('angle');
pause;
subplot(2,2,1)
plot(alpha,arge(:,1),'k-',alpha,argb(:,1),'k:');
xlabel('angle');
subplot(2,2,2)
plot(alpha,arge(:,2),'k-',alpha,argb(:,2),'k:');
xlabel('angle');
subplot(2,2,3)
plot(alpha,arge(:,3),'k-',alpha,argb(:,3),'k:');
xlabel('angle');
subplot(2,2,4)
plot(alpha,arge(:,4),'k-',alpha,argb(:,4),'k:');
xlabel('angle');
pause;
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% % 
% clear all;
% % background wavelength = 1
% lambda0=1;
% k0=2*pi/lambda0;
% % radius of cylinder a0
% a0=4*lambda0;
% % max l=k00*a0;
% L=round(k0*a0)+5;
% % set  n of cylinder
% nc=[1.005,1.01,1.015,1.02];
% % set up angles to compute scattering amplitude
% Nalpha=1024;
% N=Nalpha;
% delalpha=2*pi/Nalpha;
% alpha=delalpha*[-Nalpha/2:Nalpha/2];
% alpha0=0;
% for ncount=1:4;
%     ncyl=nc(ncount);
%     k=k0*ncyl;
% %
% % compute scattering amplitudes 
% % 
% % loop over bessel indicies l
%     % highest index = k0*a0
%          for l=1:L;
%              ll=l-1;           
%     % compute transmission coefficient from chap 8
%      denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
%      numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
%      mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
%      end;
% % compute transmission function
% T=2*i/(pi*k0*a0)./(denom+eps);
% % T(nf,ni,l) argument=#frequencies, # indicies, index # of bessel functions
% R=(numer+eps)./(denom+eps);
% %
% % compute scattering amplitudes as function of angle
% %
% for na=1:Nalpha+1;
%     fs=0;fsb=0;
%     for l=2:L;
%         ll=l-1;
%         fs=fs+R(l)*cos(ll*(alpha(na)-alpha0));
%         fsb=fsb+mu0(l)*cos(ll*(alpha(na)-alpha0));
%     end;
%     fsc(na)=sqrt(2/(pi*k0))*exp(-i*pi/4)*(R(1)+2*fs);
%     fsbo(na)=-sqrt(pi/(2*k0))*exp(i*pi/4)*k0^2*(1-ncyl^2)*(mu0(1)+2*fsb);
% end;
% %%%%%%%%%%%%%%%
% % compute ideal born using closed form
% %%%%%%%%%%%%%%%
% fsbornp(:,ncount)=-sqrt(pi/(2*k0))*k0^2*a0^2*exp(i*pi/4)*(1-ncyl^2)*(besselj(1,sqrt(2)*k0*a0*sqrt(1-cos(alpha)))+eps)./(sqrt(2)*k0*a0*sqrt(1-cos(alpha))+eps);
% fsbornp(N/2+1,ncount)=-sqrt(pi/(2*k0))*k0^2*a0^2*exp(i*pi/4)*(1-ncyl^2)/2;
% fscat(:,ncount)=fsc;
% fsborn(:,ncount)=fsbo;
% end;
% %
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fscatf=repmat(abs(sin(alpha.')),1,4).*fscat;
fsbornf=repmat(abs(sin(alpha.')),1,4).*fsborn;
%fsbornpf=repmat(abs(sin(alpha.')),1,4).*fsbornp;
fscatf1=repmat(hamming(N+1),1,4).*fscatf;
fsbornf1=repmat(hamming(N+1),1,4).*fsbornf;
%fsbornpf1=repmat(hamming(N+1),1,4).*fsbornpf;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma=k0*cos(alpha);
delr=2*a0/N;
Kbr=sqrt(1-gamma/k0).';
r=delr*[0:N];
argbr=sqrt(2)*k0*r.'*Kbr.';
%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%
Xgbr=besselj(0,argbr);
%%%%%%%%%%%%%%%%%
outborn=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornf;
outscat=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fscatf;
%outbornp=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornpf;
outborn1=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornf1;
outscat1=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fscatf1;
%outbornp1=-delalpha*sqrt(8*pi*k0)*k0^2/(4*pi)*exp(-i*pi/4)*Xgbr*fsbornpf1;
clf;
subplot(2,2,1)
plot(r,real(outscat(:,1)),'k-',r,real(outborn(:,1)),'k--');
subplot(2,2,2)
plot(r,real(outscat(:,2)),'k-',r,real(outborn(:,2)),'k--')
subplot(2,2,3)
plot(r,real(outscat(:,3)),'k-',r,real(outborn(:,3)),'k--')
subplot(2,2,4)
plot(r,real(outscat(:,4)),'k-',r,real(outborn(:,4)),'k--')
pause;
subplot(2,2,1)
plot(r,real(outscat1(:,1)),'k-',r,real(outborn1(:,1)),'k--');
subplot(2,2,2)
plot(r,real(outscat1(:,2)),'k-',r,real(outborn1(:,2)),'k--')
subplot(2,2,3)
plot(r,real(outscat1(:,3)),'k-',r,real(outborn1(:,3)),'k--')
subplot(2,2,4)
plot(r,real(outscat1(:,4)),'k-',r,real(outborn1(:,4)),'k--')
pause;
clf;
subplot(2,1,1)
plot(r,real(outscat),'k-',r,real(outborn),'k--')
subplot(2,1,2)
plot(r,real(outscat1),'k-',r,real(outborn1),'k--')

%
% compute theoretical born inverse
%
% hamming filter
%
% h=hamming(2*N); 
% hf=h(N:2*N);
% delK=2*k0/N;
% K=delK*[0:N];
% Kr=r.'*K;
% Vhat=a0*(k0^2-k^2)*delK*besselj(0,Kr)*besselj(1,K*a0).';
% Vhatf=a0*(k0^2-k^2)*delK*besselj(0,Kr)*(hf.*besselj(1,K*a0).');
% %plot(r,imag(outbornp),'b-',r,real(Vhat),'k-')
% plot(r,Vhat,'k-',r,Vhatf,'k:',r,real(outbornp),'b-')
% pause;
%

