% program chap8_3.m
% modification of program bornrytov1.m
% modification of cylscat4.m
% this program computes the exact and born approximations of the field scattered
% by a penetrable cylinder at fixed wavelength and four different indicies 
% refraction of the cylinder and then implements the FBP algorithm to
% reconstruct the index profiles for the four cases
%  
% based on the theory developed in chapter 8 of book
% used to generate figs.8.4-8.8 in chapter 8 of book.
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of cylinder a0
%a0=6*lambda0;
a0=12*lambda0;
% max l=k00*a0;
L=round(k00*a0)+20;
Ll=[0:L-1];
% set  n of cylinder
nc=[1.01,1.015,1.02,1.025];
k0=k00; 
% distance to measurement line
z0=a0+2*lambda0;
% x=r sin phi=z tan phi, 
%x0=z0*tan(pi/4);
x0=6*a0;
Nx=1024;
delx=2*x0/Nx;
x=[-x0:delx:x0];
Nx=length(x);
% phi=atan(x/z0);
phi=atan(x/z0).';
% r=sqrt(x^2+z0^2)
kr=k0*sqrt(x.^2+z0^2).';
% 
% set up fast computation using array processing
%%%
% compute for l=0 to L-1
%
H1=2*cos(phi*Ll);
H1(:,1)=1;
H=besselh(Ll,kr).*H1;
%
% zero angle of incidence of plane wave
alpha0=0;
% 
% loop over cylinder indicies
% 
for ncount=1:4;
    ncyl=nc(ncount);
    k=k0*ncyl;
% loop over bessel indicies l
    % highest index =L-1
         for l=1:L;
             ll=l-1;           
    % compute transmission coefficient from chap 8
     denom(l)=besselj(ll,k*a0).*besselder(ll,k0*a0,1)-ncyl*besselder(ll,k*a0,0).*besselh(ll,k0*a0);
     numer(l)=ncyl*besselj(ll,k0*a0).*besselder(ll,k*a0,0)-  besselder(ll,k0*a0,0).*besselj(ll,k*a0);
     mu0(l)= a0^2/2.*((besselj(ll,k0*a0)).^2-besselj(ll-1,k0*a0).*besselj(ll+1,k0*a0));
     end;
R=numer./(denom+eps);
% Born reflection coefficient
RB=-i*pi/2*k0^2*(1-ncyl^2)*mu0;
%
% compute scattered field over line located at z0
%
%  perform computation using array processing
%
% use results from chap 8 on born scat from cylinder
%
% exact
% 
bl=i.^(Ll).*R;
% Born
blB=i.^(Ll).*RB;
%
% compute scattered field over line at l0
%
Us(:,ncount)=H*bl.';
Ubs(:,ncount)=H*blB.';
end;
%
% plot results
%
% compute exact, born and Rytov  total fields over measurement line
% Ut, Ubt, and UR=total fields
% U=exp(i*k0*z0)+U;
 phirytov=z0-i/k0*exp(-i*k0*z0)*Ubs;
% Ub=exp(i*k0*z0)+Ub;
U=Us+exp(i*k0*z0);
Ub=Ubs+exp(i*k0*z0);
 UR=exp(i*k0*phirytov);
 URs=UR-exp(i*k0*z0);
 ang=unwrap(angle(U)/k0,[],1);
 angb=unwrap(angle(Ub)/k0,[],1);
 angr=unwrap(angle(UR)/k0,[],1);
delW=log(U)./(i*k0)-log(exp(i*k0*z0))./(i*k0);
%delWr=log(UR)./(i*k0)-log(exp(i*k0*z0))./(i*k0);
delWr=phirytov-z0;
subplot(2,1,1)
plot(x,real(delW),'k-',x,real(delWr),'k--');
subplot(2,1,2)
plot(x,imag(delW),'k-',x,imag(delWr),'k--');
pause;
% subplot(2,2,1)
% plot(x,abs(URs(:,1)),'k--',x,abs(Us(:,1)),'k-',x,abs(Ubs(:,1)),':k');
% xlabel('x');
% subplot(2,2,2)
% plot(x,abs(URs(:,2)),'k--',x,abs(Us(:,2)),'k-',x,abs(Ubs(:,2)),':k');
% xlabel('x');
% subplot(2,2,3)
% plot(x,abs(URs(:,3)),'k--',x,abs(Us(:,3)),'k-',x,abs(Ubs(:,3)),':k');
% xlabel('x');
% subplot(2,2,4)
% plot(x,abs(URs(:,4)),'k--',x,abs(Us(:,4)),'k-',x,abs(Ubs(:,4)),':k');
% xlabel('x');
% pause;
% subplot(2,2,1)
% plot(x,angr(:,1),'k--',x,ang(:,1),'k-',x,angb(:,1),':k');
% xlabel('x');
% subplot(2,2,2)
% plot(x,angr(:,2),'k--',x,ang(:,2),'k-',x,angb(:,2),':k');
% xlabel('x');
% subplot(2,2,3)
% plot(x,angr(:,3),'k--',x,ang(:,3),'k-',x,angb(:,3),':k');
% xlabel('x');
% subplot(2,2,4)
% plot(x,angr(:,4),'k--',x,ang(:,4),'k-',x,angb(:,4),':k');
% xlabel('x');
% pause;
% clf;
% subplot(2,1,1)
% plot(x,real(delW),'k-',x,real(delWr),'k--');
% subplot(2,1,2)
% plot(x,ang,'k-',x,angr,'k--');
% pause;
% 
% implement FBP algorithm
%
N=Nx-1;
delK=.99*k0/N;
K=delK*[0:N].';
H=delx*exp(-i*K*x);
gam=sqrt(k0^2-K.^2).';
delWtil=H*delW;
delWrtil=H*delWr;
% subplot(2,2,1)
% plot(K, abs(delWtil),'-k');
% subplot(2,2,2)
% plot(K, angle(delWtil),'-k');
% subplot(2,2,3)
% plot(K, abs(delWrtil),'-k');
% subplot(2,2,4)
% plot(K,angle(delWrtil),'-k');
% pause;
% subplot(2,2,1)
% plot(K, real(delWtil),'-k');
% subplot(2,2,2)
% plot(K, imag(delWtil),'-k');
% subplot(2,2,3)
% plot(K, real(delWrtil),'-k');
% subplot(2,2,4)
% plot(K, imag(delWrtil),'-k');
% pause;
%
% perform inversion using FBP algorithm
%
filh=hamming(2*Nx);
delr=2*a0/N;
r=delr*[0:N].';
argr=repmat(r,1,Nx);
argam=repmat(gam,Nx,1);
H2=delK/(2*pi)*besselj(0,sqrt(2)*k0*sqrt(1-argam./k0).*argr);
% 
% now for CT inversion
%
argK=repmat(K.',Nx,1);
H2ct=delK/(2*pi)*besselj(0,argK.*argr);
for ncount=1:4;
delWtilf(:,ncount)=exp(i*(k0-gam.')*z0).*K.*delWtil(:,ncount).*filh(Nx+1:2*Nx);
deln(:,ncount)=H2*delWtilf(:,ncount);
delWrtilf(:,ncount)=exp(i*(k0-gam.')*z0).*K.*delWrtil(:,ncount).*filh(Nx+1:2*Nx);
delnr(:,ncount)=H2*delWrtilf(:,ncount);
delWtilct(:,ncount)=K.*delWtil(:,ncount).*filh(Nx+1:2*Nx);
delnct(:,ncount)=H2ct*delWtilct(:,ncount);
end;
subplot(2,1,1)
plot(r,real(deln),'k-');
grid on;
subplot(2,1,2)
plot(r,real(delnr),'k-');
grid on;
pause;
clf;
plot(r,real(delnct),'k-');
grid on;
 