% program chap8_4.m
% modification of program chap8_3.m
% this program computes the exact and born approximations of the field scattered
% by a pair of penetrable cylinder at fixed wavelength and four different indicies 
% refraction of the cylinders and then implements the FBP algorithm to
% reconstruct the index profiles for the four cases
%  
% based on the theory developed in chapter 8 of book
% used to generate fig.8.9 in chapter 8 of book
clear all;
% background wavelength = 1
lambda0=1;
k0=2*pi/lambda0;
% x=r sin phi=z tan phi, 
%x0=z0*tan(pi/4);
% radius of inner cylinder a1
a1=2*lambda0;
% radius of outer cylinder a2
a2=8*lambda0;
% distance to measurement line
z0=a2+2*lambda0;
x0=6*a2;
Nx=1024;
delx=4*a2/Nx;
x=[-2*a2:delx:2*a2];
Nx=length(x);
% phi=atan(x/z0);
phi=atan(x/z0).';
% r=sqrt(x^2+z0^2)
kr=k0*sqrt(x.^2+z0^2).';
% max l=k0*a2;
L=round(k0*a2);
L1=[0:L-1];
% set  n1 of inner cylinder
nc1=[1.05,1.05];
% set  n2 of outer cylinder shell
nc2=[1.01,1.01];
% set up angles to compute scattering amplitude
Nalpha=Nx;
alpha=phi;
alpha0=0;
% 
% set up fast computation using array processing
%%%
% compute for l=0 to L-1
%
H1=2*cos(phi*L1);
H1(:,1)=1;
H=besselh(L1,kr).*H1;
% %
% % zero angle of incidence of plane wave
% alpha0=0;
% 
% loop over cylinder indicies
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% loop over cylinder indicies
% 
ncount=0;
for ncount1=1:2;
    ncyl1=nc1(ncount1);
    k1=k0*ncyl1;
    for ncount2=1:2;
        ncyl2=nc2(ncount2);
    k2=k0*ncyl2;
    ncount=1+ncount;
% loop over bessel indicies l
    % highest index = k0*a0
         for l=1:L;
             ll=l-1;           
    % compute matrix elements from chap 8
    row1=[-besselj(ll,k1*a1),besselj(ll,k2*a1),0,besselh(ll,k2*a1)];
    row2=[-ncyl1*besselder(ll,k1*a1,0),ncyl2*besselder(ll,k2*a1,0),0,ncyl2*besselder(ll,k2*a1,1)];
    row3=[0,besselj(ll,k2*a2),-besselh(ll,k0*a2),besselh(ll,k2*a2)];
    row4=[0,ncyl2*besselder(ll,k2*a2,0),-besselder(ll,k0*a2,1),ncyl2*besselder(ll,k2*a2,1)];
    Hp=[row1;row2;row3;row4]+eps*eye(4);
    amp3=besselj(ll,k0*a2);
    amp4=besselder(ll,k0*a2,0);
    A0=[0;0;amp3;amp4];
    A(:,l)=inv(Hp)*A0; 
    % now do born
    mu1(l)= a1^2/2.*((besselj(ll,k0*a1)).^2-besselj(ll-1,k0*a1).*besselj(ll+1,k0*a1));
     mu2(l)= a2^2/2.*((besselj(ll,k0*a2)).^2-besselj(ll-1,k0*a2).*besselj(ll+1,k0*a2));
          end;
%
% compute scattered field over line at l0
%
R=A(3,:);
% Born reflection coefficient
RB=-i*pi/2*k0^2*((ncyl2^2-ncyl1^2)*mu1+(1-ncyl2^2)*mu2);
%
%
% compute scattered field over line located at z0
%
%  perform computation using array processing
%
% use results from chap 8 on born scat from cylinder
%
% exact
% 
bl=i.^(L1).*R;
% Born
blB=i.^(L1).*RB;
%
% compute scattered field over line at l0
%
Us(:,ncount)=H*bl.';
Ubs(:,ncount)=H*blB.';
end;
end;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% plot results
%
% compute exact, born and Rytov  total fields over measurement line
% Ut, Ubt, and UR=total fields
% U=exp(i*k0*z0)+U;
 phirytov=z0-i/k0*exp(-i*k0*z0)*Ubs;
% Ub=exp(i*k0*z0)+Ub;
U=Us+exp(i*k0*z0);
Ub=Ubs+exp(i*k0*z0);
 UR=exp(i*k0*phirytov);
 URs=UR-exp(i*k0*z0);
 ang=unwrap(angle(U)/k0,[],1);
 angb=unwrap(angle(Ub)/k0,[],1);
 angr=unwrap(angle(UR)/k0,[],1);
delW=log(U)./(i*k0)-log(exp(i*k0*z0))./(i*k0);
delWr=log(UR)./(i*k0)-log(exp(i*k0*z0))./(i*k0);;
% subplot(2,1,1)
% plot(x,real(delW),'k-',x,real(delWr),'k--');
% subplot(2,1,2)
% plot(x,imag(delW),'k-',x,imag(delWr),'k--');
% pause;
% subplot(2,2,1)
% plot(x,abs(URs(:,1)),'k--',x,abs(Us(:,1)),'k-',x,abs(Ubs(:,1)),':k');
% xlabel('x');
% subplot(2,2,2)
% plot(x,abs(URs(:,2)),'k--',x,abs(Us(:,2)),'k-',x,abs(Ubs(:,2)),':k');
% xlabel('x');
% subplot(2,2,3)
% plot(x,abs(URs(:,3)),'k--',x,abs(Us(:,3)),'k-',x,abs(Ubs(:,3)),':k');
% xlabel('x');
% subplot(2,2,4)
% plot(x,abs(URs(:,4)),'k--',x,abs(Us(:,4)),'k-',x,abs(Ubs(:,4)),':k');
% xlabel('x');
% pause;
% subplot(2,2,1)
% plot(x,angr(:,1),'k--',x,ang(:,1),'k-',x,angb(:,1),':k');
% xlabel('x');
% subplot(2,2,2)
% plot(x,angr(:,2),'k--',x,ang(:,2),'k-',x,angb(:,2),':k');
% xlabel('x');
% subplot(2,2,3)
% plot(x,angr(:,3),'k--',x,ang(:,3),'k-',x,angb(:,3),':k');
% xlabel('x');
% subplot(2,2,4)
% plot(x,angr(:,4),'k--',x,ang(:,4),'k-',x,angb(:,4),':k');
% xlabel('x');
% pause;
% clf;
% subplot(2,1,1)
% plot(x,real(delW),'k-',x,real(delWr),'k--');
% subplot(2,1,2)
% plot(x,ang,'k-',x,angr,'k--');
% pause;
% 
% implement FBP algorithm
%
N=Nx-1;
delK=.99*k0/N;
K=delK*[0:N].';
H=delx*exp(-i*K*x);
gam=sqrt(k0^2-K.^2).';
delWtil=H*delW;
delWrtil=H*delWr;
% subplot(2,2,1)
% plot(K, abs(delWtil),'-k');
% subplot(2,2,2)
% plot(K, angle(delWtil),'-k');
% subplot(2,2,3)
% plot(K, abs(delWrtil),'-k');
% subplot(2,2,4)
% plot(K,angle(delWrtil),'-k');
% pause;
% subplot(2,2,1)
% plot(K, real(delWtil),'-k');
% subplot(2,2,2)
% plot(K, imag(delWtil),'-k');
% subplot(2,2,3)
% plot(K, real(delWrtil),'-k');
% subplot(2,2,4)
% plot(K, imag(delWrtil),'-k');
% pause;
%
% perform inversion using FBP algorithm
%
filh=hamming(2*Nx);
delr=2*a2/N;
r=delr*[0:N].';
argr=repmat(r,1,Nx);
argam=repmat(gam,Nx,1);
H2=delK/(2*pi)*besselj(0,sqrt(2)*k0*sqrt(1-argam./k0).*argr);
% 
% now for CT inversion
%
argK=repmat(K.',Nx,1);
H2ct=delK/(2*pi)*besselj(0,argK.*argr);
for ncount=1:4;
delWtilf(:,ncount)=exp(i*(k0-gam.')*z0).*K.*delWtil(:,ncount).*filh(Nx+1:2*Nx);
deln(:,ncount)=H2*delWtilf(:,ncount);
delWrtilf(:,ncount)=exp(i*(k0-gam.')*z0).*K.*delWrtil(:,ncount).*filh(Nx+1:2*Nx);
delnr(:,ncount)=H2*delWrtilf(:,ncount);
delWtilct(:,ncount)=K.*delWtil(:,ncount).*filh(Nx+1:2*Nx);
delnct(:,ncount)=H2ct*delWtilct(:,ncount);
end;
subplot(2,1,1)
plot(r,real(deln),'k-');
grid on;
subplot(2,1,2)
plot(r,real(delnr),'k:');
grid on;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% generate image superimposing a number of views
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% first generate 2D polar data of images of deln and delnr
%%%%
dphi=2*pi/Nx;
phip=dphi*[0:Nx-1];
for ncc=1:4;
delnp(:,:,ncc)=repmat(deln(:,ncc).',Nx,1);
delnrp(:,:,ncc)=repmat(delnr(:,ncc).',Nx,1);
end;
[Phi,R]=ndgrid(phip,r);
[x,y]=pol2cart(Phi,R);
% subplot(2,2,1)
% mesh(x,y,real(delnp(:,:,1)));
% axis image;
% view(0,90);
% colorbar;
% colormap(gray);
% subplot(2,2,2)
% mesh(x,y,real(delnp(:,:,2)));
% axis image;
% view(0,90);
% colorbar;
% colormap(gray);
% subplot(2,2,3)
% mesh(x,y,real(delnp(:,:,3)));
% axis image;
% view(0,90);
% colorbar;
% colormap(gray);
% subplot(2,2,4)
% mesh(x,y,real(delnp(:,:,4)));
% axis image;
% view(0,90);
% colorbar;
% colormap(gray);
% 
subplot(2,2,1)
plot(r,real(deln(:,4)),'k-');
grid on;
subplot(2,2,2)
mesh(x,y,real(delnp(:,:,4)));
view(3)
subplot(2,2,3)
plot(r,real(delnr(:,4)),'k-');
grid on;
subplot(2,2,4)
mesh(x,y,real(delnrp(:,:,4)));
view(3)




