% program chap8_5.m
% does ideal simulations of CT and DT for chapter 8 of book
% written by a.j.devaney nov 2010
% used to generate figs8.10-8.13 in chapter 8 of book.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all;
lambda=.1;
k0=2*pi/lambda;
Nx=512;
% 
Ny=Nx;
l0=100;
lx=100;
delx=lx/Nx;
% x=horiz axis
x=delx*[-Nx/2:Nx/2-1];
% y=vert axis
y=-x.';
% used for generating FBP image
% Xi=repmat(x,Ny,1);
% Eta=repmat(y,1,Nx);
[Xi,Eta] =meshgrid(x,y);
delKx=2*pi/(Nx*delx);
% create LP filter for generating ideal reconstruction
% H=zeros(Nx);
% ra=sqrt(2)*k0;
% na=ceil(ra/delKx);
% n1=Nx/2-na;
% n2=Nx/2+na;
% H(n1:n2,n1:n2) = fspecial('disk',na);
% H=H./(max(max(H)));
Kx=delKx*[-Nx/2:Nx/2-1];
Ky=-Kx.';
KX=repmat(Kx,Ny,1);
KY=repmat(Ky,1,Nx);
K=sqrt(KX.^2+KY.^2);
rho=[0,0;0,-.92;11,0;-11,0;0,17.5;0,5;0,-5;-4,-30.25;0,-30.25;3,-30.25];
deln=[.5,-.5,-.2,-.2,.1,.15,.15,.15,.15,.15];
aj=[40.25,38.42,10.5,14.25,11.5,2.3,2.3,2.3,1.15,1.725];
delntil=zeros(Nx,Ny);
for nct=1:10;
  delntil=delntil+2*pi*deln(nct)*(besselj(1,K*aj(nct))+eps)./(K+eps).*exp(-i*(KX*rho(nct,1)+KY*rho(nct,2)));
  end;
  % generate perfect reconstruction with no LP filtering
deltan=ifft2(fftshift(delntil))*Nx^2*delKx^2/(2*pi)^2;
%
% compute phase over measurement line
%
%Nphi=109;
Nphi=31;
delphi=2*pi/Nphi;
phi=delphi*[0:Nphi-1];   
kappa=Kx;
nn=round(k0/delKx);
if nn>= round(Nx/2)
    nn=round(Nx/2)-2;
end;
I1=find(Kx==-nn*delKx)+1;
I2=find(Kx==nn*delKx)-1;
fil=zeros(1,Nx);
fil(I1:I2)=hamming(I2-I1+1).';
gamma=sqrt(k0^2-kappa.^2);
gamma(1:I1)=0;
gamma(I2:Nx)=0;
tilW=zeros(1,Nx);
fac1=2*pi*k0*(exp(i*(gamma-k0)*l0)+eps)./(gamma+eps);
fac2=sqrt(2*k0*(k0-gamma));
Kappa=repmat(abs(kappa),Ny,1);
Fil=repmat(fil,Ny,1);
array2=repmat(gamma,Ny,1);
Out=zeros(Nx,Ny,Nphi);
for nphi=1:Nphi;
    tilW=zeros(1,Nx);
   for nct=1:10;
    eta=-rho(nct,1)*sin(phi(nphi))+rho(nct,2)*cos(phi(nphi));
    xi=rho(nct,1)*cos(phi(nphi))+rho(nct,2)*sin(phi(nphi));
tilW=tilW+fac1.*deln(nct).*(besselj(1,fac2*aj(nct))+eps)./(fac2+eps).*exp(-i*(kappa*xi+(gamma-k0)*eta));
  end;
tilW(1:I1)=0;
tilW(I2:Nx)=0;
% compute phase over measurement lines
W(nphi,:)=ifft(fftshift(tilW))*Nx*delKx/(2*pi);
% 
% generate partial via via FBP algorithm
% 
% Fil is smooting filter to remove Gibbs 
array1=repmat(tilW,Ny,1).*Kappa.*Fil;
array=array1.*exp(i*(array2-k0).*(Eta-l0))./(8*pi^2);
arrayct=array1./(8*pi^2);
array3=fftshift(array,2);
array3ct=fftshift(arrayct,2);
out=ifft(array3,[],2)*Nx*delKx;
out=fftshift(out,2);
outct=ifft(array3ct,[],2)*Nx*delKx;
outct=fftshift(outct,2);
X=Xi*cos(phi(nphi))+Eta*sin(phi(nphi));
Y=-Xi*sin(phi(nphi))+Eta*cos(phi(nphi));
Out(:,:,nphi)=interp2(Xi,Eta,out,X,Y);
Outct(:,:,nphi)=interp2(Xi,Eta,outct,X,Y);
end;
image1p=delphi*sum(Out,3);
image1=sum(Out(:,:,1:9:Nphi),3)*2*pi./4;
image2=sum(Out(:,:,1:6:Nphi),3)*2*pi/6;
image3=sum(Out(:,:,1:3:Nphi),3)*2*pi/11;
image4=sum(Out,3)*2*pi/31;
%image1ct=delphi*sum(Outct,3);
image1ct=sum(Outct(:,:,1:9:Nphi),3)*2*pi./4;;
image2ct=sum(Outct(:,:,1:6:Nphi),3)*2*pi/6;
image3ct=sum(Outct(:,:,1:3:Nphi),3)*2*pi/11;
image4ct=sum(Outct,3)*2*pi/31;
subplot(2,2,1)
imagesc(x,y,real(image1));
axis image;
colormap(gray)
colorbar;
subplot(2,2,2)
imagesc(x,y,real(image2));
axis image;
colormap(gray)
colorbar;
subplot(2,2,3)
imagesc(x,y,real(image3));
axis image;
colormap(gray)
colorbar;
subplot(2,2,4)
imagesc(x,y,real(image4));
axis image;
colormap(gray) 
colorbar;
pause;
subplot(2,2,1)
imagesc(x,y,real(image1ct));
axis image;
colormap(gray)
colorbar;
subplot(2,2,2)
imagesc(x,y,real(image2ct));
axis image;
colormap(gray)
colorbar;
subplot(2,2,3)
imagesc(x,y,real(image3ct));
axis image;
colormap(gray)
colorbar;
subplot(2,2,4)
imagesc(x,y,real(image4ct));
axis image;
colormap(gray) 
colorbar;
pause
subplot(1,2,1)
imagesc(x,y,real(fftshift(deltan)));
axis image
colormap('default');
colorbar
subplot(1,2,2)
 imagesc(x,y,real(image1p));
axis image;
 colormap('default')  
 colorbar
 pause;

 
