% program chap9_1.m
% program computes and plots singular values ratio of sigma_l to h_l
% illustrating lack of super-resolution  of 2D ISP
% used for fig.9.1 in chapter 9 of book
clear all;
lambda=1;
a=4*lambda;
k=2*pi/lambda;
ka=k*a;
nr=1.5;
n0=1;
Lmax=round(ka*nr+50);
L=[1:Lmax];
% first compute singular values for homogeneous backgrounds
mu1=(spherebess(L,n0*ka,0).^2-spherebess(L-1,n0*ka,0).*spherebess(L+1,n0*ka,0));
mu2=(spherebess(L,nr*ka,0).^2-spherebess(L-1,nr*ka,0).*spherebess(L+1,nr*ka,0));
mu1=mu1./(mu1(1)); mu2=mu2./(mu2(1));
% now compute transmission coefficients a_l^m
temp=spherebess(L,nr*ka,0).*spherebesselder(L,n0*ka,1)-nr*spherebesselder(L,nr*ka,0).*spherebess(L,n0*ka,1);
a_l=i./(temp+eps);
sig2=abs(a_l.*mu2);
sig2=sig2./(sig2(1));
semilogy(L,mu1,'k-',L,mu2,'b+-',L,sig2,'r*-');
grid on