% program chap9_3.m
% this program computes the limited view iscp from chapter 11 for a pair of
% cylinders in a homogeneous background using pure Born data
% generates figs 9.8 and 9.9 in chapter 9 of book
clear all;
clf;
% wavelength
lambda=1;
k_0=2*pi/lambda;
% image grid
delx=lambda/16; dely=delx;
N=256;
x=delx*[-N/2:N/2-1]; y=x;
[X,Y]=meshgrid(x,y);
% scattering strengths, centers, radii
C=[1,1]; xc=[-1,1]*lambda; yc=[0,0]*lambda; a=[1,1]*lambda;
% scatterer support
a_0=5*lambda;
V1=zeros(N,N);V2=V1;
%[Ix,Iy]=find(X.^2+Y.^2<(32*delx)^2);
V1(find(X.^2+Y.^2<a_0^2)) = 1;
% 
% construct scattering potential transform
%
delKx=2*pi/(N*delx); delKy=delKx;
Kx=delKx*[-N/2:N/2-1]; Ky=Kx;
[KX,KY]=meshgrid(Kx,Ky);
K=sqrt(KX.^2+KY.^2);
Vtil=2*pi*C(1)*a(1)*besselj(1,(K+eps)*a(1))./(K+eps).*exp(-i*(KX*xc(1)+KY*yc(1))); 
Vtil=Vtil+2*pi*C(2)*a(2)*besselj(1,(K+eps)*a(2))./(K+eps).*exp(-i*(KX*xc(2)+KY*yc(2))); 
V=1./(delx*dely)*ifft2(fftshift(Vtil));
% clf;
% mesh(fftshift(real(V)));
% axis equal;
% pause;
% 
% compute scattering amplitude
% Nphi and Nphi_0 odd
%
Nphi=17; Nphi_0=17;Vtil=zeros(Nphi,Nphi_0);
delphi=(pi)/Nphi; delphi_0=(2*pi)/Nphi_0;
phi_0=delphi_0*[-(Nphi_0-1)/2:(Nphi_0-1)/2];
phi=delphi*[-(Nphi-1)/2:(Nphi-1)/2]; 
for nphi_0=1:Nphi_0;
    phid=phi+phi_0(nphi_0);
    for nphi=1:Nphi;
        Ktx=k_0*(sin(phid(nphi))-sin(phi_0(nphi_0)));
        Kty=k_0*(cos(phid(nphi))-cos(phi_0(nphi_0)));
        Kt=sqrt(Ktx^2+Kty^2);
        temp=2*pi*C(1)*a(1)*besselj(1,(Kt+eps)*a(1))./(Kt+eps).*exp(-i*(Ktx*xc(1)+Kty*yc(1)));
        vtil(nphi,nphi_0)=temp+2*pi*C(2)*a(2)*besselj(1,(Kt+eps)*a(2))./(Kt+eps).*exp(-i*(Ktx*xc(2)+Kty*yc(2)));
    end;
end;
%
% now compute scattering amplitude
%
f=-sqrt(1./(8*pi*k_0)).*exp(i*pi/4).*vtil;
plot(phi,(abs(f(:,1))),'k.-',phi,(abs(f(:,3))),'k.-',phi,(abs(f(:,5))),'k.-',phi,(abs(f(:,7))),'k.-');
pause;
%
% construct deltaf used in inversion
% deltaf indexed by n=nphi+(nphi_0-1)*Nphi;
%
% for nphi_0=1:Nphi_0;
%     for nphi=1:Nphi;
%          n=nphi+(nphi_0-1)*Nphi;
%          deltaf(n)=sqrt(k_0/(2*pi))*exp(-i*pi/4)*f(nphi,nphi_0);
%       end;
% end;
deltaf=sqrt(k_0/(2*pi))*exp(-i*pi/4)*reshape(f,Nphi*Nphi_0,1);
%
% convert to column vector
%
% deltaf=deltaf.';
%
% compute matrix 
%
for nphi_0=1:Nphi_0;
    nphi_0
    for nphi=1:Nphi;
         n=nphi+(nphi_0-1)*Nphi;
         phid=phi+phi_0(nphi_0);
        for nphip_0=1:Nphi_0;
                 for nphip=1:Nphi;
                     np=nphip+(nphip_0-1)*Nphi; 
                     phidp=phi+phi_0(nphip_0);
        Ktx=k_0*(sin(phid(nphi))-sin(phi_0(nphi_0)));
        Kty=k_0*(cos(phid(nphi))-cos(phi_0(nphi_0)));
        Ktxp=k_0*(sin(phidp(nphip))-sin(phi_0(nphip_0)));
        Ktyp=k_0*(cos(phidp(nphip))-cos(phi_0(nphip_0)));
        Kttx=Ktx-Ktxp;
        Ktty=Kty-Ktyp;
        Ktt=sqrt(Kttx^2+Ktty^2);            
        H(n,np)=a_0^2/(8*pi)*besselj(1,(Ktt+eps)*a_0)./((Ktt+eps)*a_0);
    end;
        end;
    end;
end;
%
% diagonalize
%
[u,d]=eig(H);
u=fliplr(u);
sig=(diag(d));
sig=sqrt(real(flipud(sig)));
P=length(find(sig>.05));
%
% now compute chi functions
%
for nphi_0=1:Nphi_0;
    for nphi=1:Nphi;
         n=nphi+(nphi_0-1)*Nphi;
         phid=phi+phi_0(nphi_0);
         Ktx=k_0*(sin(phid(nphi))-sin(phi_0(nphi_0)));
        Kty=k_0*(cos(phid(nphi))-cos(phi_0(nphi_0)));
        chi(:,:,n)=-1./(4*pi)*exp(i*(Ktx*X+Kty*Y));
    end;
end;
% 
% construct inverse
%
% compute expansion coefficients  
%
for p=1:P;
    A(p)=u(:,p)'*deltaf;
end;
%
% compute singular functions v_p
%
for p=1:P;
  temp=zeros(N,N);
for n=1:Nphi*Nphi_0;
    temp=temp+u(n,p)*chi(:,:,n);
end;
v(:,:,p)=temp;
end;
%    
% now compute inverse
%
temp1=zeros(N,N);
temp2=temp1;
for p=1:P;
      temp1=temp1+A(p)*v(:,:,p)./sig(p);
      temp2=temp2+A(p)*v(:,:,p).*sig(p);
end;
hatV1=temp1.*V1;
%hatV2=temp2.*V1;
thet=[0:.1:2*pi];
x1=xc(1)+a(1)*cos(thet);
y1=yc(1)+a(1)*sin(thet);
x2=xc(2)+a(2)*cos(thet);
y2=yc(2)+a(2)*sin(thet);
imagesc(x,y,real(hatV1));
axis equal; 
axis([-6,6,-6,6]);
colorbar
hold on
plot(x1,y1,'k-');
plot(x2,y2,'k-');
colormap(gray)



