% function multistatic1.m
function [K] = multistatic1(X,Y,V);
global lambda xalpha xbeta yalpha ybeta  
%
% program computes the multistatic data matrix at a single frequency in 2D
% homogeneous space
%
% compute antenna functions 
% G=-i/4H_0(kR)
% antenna functions=colum vectors constructed from G
% ga_m=G(|r_a-r_m|), gb_m=G(|r_b-r_m|)
% r_a=\hat x xalpha+\hat y yalpha; r_b=\hat x xbeta+\hat y ybeta
% r_m=\hat x X_m+\hat y Y_m
% Ra=|r_a-r_m|, Rb=|r_b-r_m|
M=length(V);Nalpha=length(xalpha); Nbeta=length(xbeta);
for m=1:M
Ra=sqrt((xalpha-X(m)).^2+(yalpha-Y(m)).^2);
Rb=sqrt((xbeta-X(m)).^2+(ybeta-Y(m)).^2);
ga(:,m)=-i/4*besselh(0,1,Ra);
gb(:,m)=-i/4*besselh(0,1,Rb);
end;
% 
% compute multistatic data matrix
%
K=zeros(Nbeta,Nalpha);
for m=1:M;
K=K+V(m)*gb(:,m)*ga(:,m).';
end;


 
