% program spherescat1.m
% this program computes the transmission and reflection coeffients of a
% penetrable sphere at a fixed background wavenumber and
% index of refraction of the sphere as a function of multipole index l
%
% based on the theory developed in chapter 8 of book
%
clear all;
% background wavelength = 1
lambda0=1;
k00=2*pi/lambda0;
% radius of sphere a0
a0=10*lambda0;
% max l=k00*a0;
L=round(k00*a0)+40;
Lmin=45;
% loop over four indicies of sphere
nn=[.75,.95,1.05,1.25];
for nct=1:4;
% set  n of sphere
nsphere=nn(nct);
k0=k00; k=nsphere*k00;
%Lmin=L-round(L/2);
% 
% loop over bessel indicies l
    % highest index = k0*a0
         for ll=Lmin:L;
             l=ll-Lmin+1;           
    % compute transmission coefficient from chap 8
     denom(l)=spherebess(ll,k*a0,0).*spherebesselder(ll,k0*a0,1)-nsphere*spherebesselder(ll,k*a0,0).*spherebess(ll,k0*a0,1);
     numer(l)=nsphere*spherebess(ll,k0*a0,0).*spherebesselder(ll,k*a0,0)- spherebesselder(ll,k0*a0,0).*spherebess(ll,k*a0,0);
     end;
% compute transmission function
T=i/(k0.^2*a0^2)./(denom+eps);
% T(nf,ni,l) argument=#frequencies, # indicies, index # of bessel functions
R=(numer)./(denom+eps);
%
% plot transmission and reflection coefficients as function of index l for
% four different frequencies k0 at fixed index of refraction
%
T0(:,nct)=abs(T.');R0(:,nct)=abs(R.');
ind=[Lmin:L];
%
% compute magnitude square of reflection coefficient for use in example in chapter 8 
% Also compute eigenvalue for source in sphere using theory in chapter 12
% first compute eigenvalues mu for free space and for sphere
%
% loop over l values
     for ll=Lmin:L;
         l=ll-Lmin+1;
         mu0(l,nct)= (spherebess(ll,k0*a0,0)).^2-spherebess(ll-1,k0*a0,0).*spherebess(ll+1,k0*a0,0);
      mun(l,nct)= (spherebess(ll,k*a0,0)).^2-spherebess(ll-1,k*a0,0).*spherebess(ll+1,k*a0,0);
      mu0p(l,nct)=R0(l,nct).^2;
     end;
     mu(:,nct)=T0(:,nct).^2.*mun(:,nct); mu0pp(:,nct)=T0(:,nct).^2.*mu0(:,nct).*mun(:,nct); 
     % normalize
     mu0(:,nct)=mu0(:,nct)./max(mu0(:,nct)); mun(:,nct)=mun(:,nct)./max(mun(:,nct)); munp(:,nct)=mu(:,nct)./max(mu(:,nct));
     mu0p(:,nct)=mu0p(:,nct)./max(mu0p(:,nct));mu0pp(:,nct)=mu0pp(:,nct)./max(mu0pp(:,nct));
end;
% subplot(2,1,1)
% semilogy(ind,T0,'k')
% subplot(2,1,2)
% semilogy(ind,R0,'k');
% pause;
% 
% plot single figure with free space mu0 and mu0p
subplot(2,2,1)
semilogy(ind,mu0(:,1),'k-',ind,mu0pp(:,1),'k--',ind,mu0p(:,1),'k.-');
%title('mu0 - mu0pp -- mu0p .-'); 
xlabel('index l');
grid on;
subplot(2,2,2)
semilogy(ind,mu0(:,2),'k-',ind,mu0pp(:,2),'k--',ind,mu0p(:,2),'k.-');
xlabel('index l');
grid on;
subplot(2,2,3)
semilogy(ind,mu0(:,3),'k-',ind,mu0pp(:,3),'k--',ind,mu0p(:,3),'k.-');
xlabel('index l');
grid on;
subplot(2,2,4)
semilogy(ind,mu0(:,4),'k-',ind,mu0pp(:,4),'k--',ind,mu0p(:,4),'k.-');
xlabel('index l');
grid on;
pause;
subplot(2,2,1)
semilogy(ind,mu0(:,1),'k-',ind,mu(:,1),'k--',ind,mu0pp(:,1),'k-.');
xlabel('index l');
title('mu0 - mu -- mun .-'); 
grid on;
subplot(2,2,2)
semilogy(ind,mu0(:,2),'k-',ind,mu(:,2),'k--',ind,mu0pp(:,2),'k-.');
xlabel('index l');
grid on;
subplot(2,2,3)
semilogy(ind,mu0(:,3),'k-',ind,mu(:,3),'k--',ind,mu0pp(:,3),'k-.');
xlabel('index l');
grid on;
subplot(2,2,4)
semilogy(ind,mu0(:,4),'k-',ind,mu(:,4),'k--',ind,mu0pp(:,4),'k-.');
xlabel('index l');
grid on;
pause;






